﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.ServiceModel;
using System.ServiceModel.Web;
using System.Text;
using System.Threading.Tasks;
using WsdlExample.EntityChangeService;

namespace WsdlExample
{
    public class WsdlService
    {
        public Guid AuthToken { get; set; }
        public string ApplicationToken { get; set; }
        public string SessionToken { get; set; }

        private ChannelFactory<EntityService.IEntityServiceChannel> _entityServiceFactory;
        private ChannelFactory<AuthorizationService.IAuthorizationServiceChannel> _authServiceFactory;
        private ChannelFactory<EntityChangeService.IEntityChangesServiceChannel> _changesServiceFactory;

        public void TestStart()
        {
            _authServiceFactory = new ChannelFactory<AuthorizationService.IAuthorizationServiceChannel>(new BasicHttpBinding(), "http://localhost:2016/API/Authorization");
            GetAuthToken();
            _entityServiceFactory = new ChannelFactory<EntityService.IEntityServiceChannel>(new BasicHttpBinding() { MaxReceivedMessageSize = Int32.MaxValue }, "http://localhost:2016/API/Entity");
            _changesServiceFactory = new ChannelFactory<EntityChangeService.IEntityChangesServiceChannel>(new BasicHttpBinding(), "http://localhost:2016/API/EntityChanges");
        }

        private string sessionToken;
        private Guid authToken;

        public void GetAuthToken()
        {
            
            var authorizationService = _authServiceFactory.CreateChannel();

            using (new OperationContextScope((IContextChannel)authorizationService))
            {
                WebOperationContext.Current.OutgoingRequest.Headers.Add("ApplicationToken", ApplicationToken);
                var token = authorizationService.LoginWithUserName("admin", "");
                authToken = token.AuthToken;
                sessionToken = token.SessionToken;
            }
            Console.WriteLine(authToken);
            Console.WriteLine(sessionToken);
        }

        public void LoadTask()
        {
            _entityServiceFactory = new ChannelFactory<EntityService.IEntityServiceChannel>(new BasicHttpBinding() { MaxReceivedMessageSize = Int32.MaxValue }, "http://localhost:2016/API/Entity");
            _authServiceFactory = new ChannelFactory<AuthorizationService.IAuthorizationServiceChannel>(new BasicHttpBinding(), "http://localhost:2016/API/Authorization");
            var entityService = _entityServiceFactory.CreateChannel();
            var authService = _authServiceFactory.CreateChannel();
            var typeUid = "f532ef81-20e1-467d-89a4-940c57a609bc";
            var id = "1";

            using (new OperationContextScope((IContextChannel)entityService))
            {

                using (new OperationContextScope((IContextChannel)authService))
                {
                    try
                    {
                        //если ошибки нет, забираем данные из ответа
                        var auth = authService.CheckToken(AuthToken);
                        AuthToken = auth.AuthToken;
                        SessionToken = auth.SessionToken;
                    }
                    catch (FaultException<AuthorizationService.PublicServiceException> ex)
                    {
                        if (ex.Detail.StatusCode == 401)
                        {
                            //если в запросе произошла ошибка авторизации, заново получаем данные для авторизации
                            WebOperationContext.Current.OutgoingRequest.Headers.Add("ApplicationToken", ApplicationToken);
                            WebOperationContext.Current.OutgoingRequest.Headers.Add("SessionToken", SessionToken);
                            var token = authService.LoginWithUserName("admin", "");
                            AuthToken = token.AuthToken;
                            SessionToken = token.SessionToken;
                        }
                        else
                        {
                            //иначе выбрасываем ошибку или дальше её обрабатываем
                            throw;
                        }
                    }
                }

                Console.WriteLine(AuthToken);
                Console.WriteLine(SessionToken);

                WebOperationContext.Current.OutgoingRequest.Headers.Add("AuthToken", AuthToken.ToString());
                WebOperationContext.Current.OutgoingRequest.Headers.Add("SessionToken", SessionToken);
                var task = entityService.Load(typeUid, id);

                foreach (var item in task.Items)
                {
                    Console.WriteLine(item.Name + ": " + item.Value);
                }
            }
            Console.ReadKey();
        }

        public void LoadTaskList()
        {
            var entityService = _entityServiceFactory.CreateChannel();
            var typeUid = "f532ef81-20e1-467d-89a4-940c57a609bc";
            
            using (new OperationContextScope((IContextChannel)entityService))
            {
                WebOperationContext.Current.OutgoingRequest.Headers.Add("AuthToken", authToken.ToString());
                WebOperationContext.Current.OutgoingRequest.Headers.Add("SessionToken", sessionToken);
                var tasks = entityService.Query(typeUid, "", "", 15, 1, "", "", "");

                foreach (var task in tasks)
                {
                    foreach (var item in task.Items)
                    {
                        Console.WriteLine(item.Name + ": " + item.Value);
                    }
                    Console.WriteLine("End of task");
                }
            }
            Console.ReadKey();
        }

        public void ChangeTest()
        {
            var changesService = _changesServiceFactory.CreateChannel();
            var typeUid = "f532ef81-20e1-467d-89a4-940c57a609bc";
            using (new OperationContextScope((IContextChannel)changesService))
            {
                WebOperationContext.Current.OutgoingRequest.Headers.Add("AuthToken", authToken.ToString());
                WebOperationContext.Current.OutgoingRequest.Headers.Add("SessionToken", sessionToken);

                //Console.WriteLine(changesService.IsSupported(typeUid));
                //var sync = new SyncChanges();
                //changesService.Sync(sync);
                
                var id = changesService.Changes(typeUid, DateTime.Now.AddHours(-2), "");
                Console.WriteLine(id.Id);
                Console.WriteLine(id.Updated.Count());

                Console.WriteLine(changesService.ChangesCommit(id.Id));

                //Console.WriteLine(changesService.ChangesCommit(id.Id));
            }
            Console.ReadKey();
        }
    }

    class Program
    {
        static void Main(string[] args)
        {
            var wsdl = new WsdlService
            {
                ApplicationToken = "285C8352AA7C67BFF882E4F236DECF51098C141AFB33A2AA4F7B34B4B3CEEF5DA30C848591DA55D5226C5D8D2C36432B12A5EF86C3D2EDF7E7C5781EC9D4E14A"
            };
            wsdl.TestStart();
            //wsdl.LoadTask();
            //Console.ReadKey();
            wsdl.ChangeTest();
            //wsdl.LoadTask();
            //wsdl.ExecuteTask();
            //wsdl.LoadTaskList();
        }
    }
}
