﻿using System;
using System.Web.Mvc;
using System.Web.Mvc.Html;
using EleWise.ELMA.ComponentModel;
using EleWise.ELMA.Files;
using EleWise.ELMA.Files.Previews;
using EleWise.ELMA.Services;
using EleWise.ELMA.Web.Mvc.Components.Previews;
using EleWise.ELMA.Web.Mvc.Models.Previews;

namespace VideoPreview.Web.Extension
{
    [Component]
    public class VideoPreviewCreatorRenderer : IFilePreviewCreatorRenderer
    {
        public static Guid UID = new Guid("{BF13D8F8-2AC4-457b-A96A-2992182AEEB5}");

        public Guid Uid
        {
            get { return UID; }
        }

        public Type CreatorType
        {
            get { return typeof(VideoPreviewCreator); }
        }

        public virtual string InitFunctionName(string uniquePrefix)
        {
            return null;
        }

        public virtual string CloseFunctionName(string uniquePrefix)
        {
            const string closePreviewFunc = "ClosePreview";
            return closePreviewFunc;
        }

        public virtual string CalcToolbarFunctionName(string uniquePrefix)
        {
            return null;
        }

        public virtual bool Render(HtmlHelper helper, BinaryFile file)
        {
            var previewService = Locator.GetServiceNotNull<IFilePreviewService>();
            var creator = previewService.GetPreviewCreator(file);
            if (creator != null)
            {
                var model = new BaseFilePreviewInfo
                {
                    File = file,
                    PreviewCreator = creator
                };

                helper.RenderPartial("Video", model);
            }
            return true;
        }
    }
}