﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using EleWise.ELMA.ComponentModel;
using EleWise.ELMA.Files;
using EleWise.ELMA.Files.Previews;
using EleWise.ELMA.Runtime;
using EleWise.ELMA;
using EleWise.ELMA.Services;
using href.Utils;

namespace VideoPreview.Web.Extension
{
    [Component]
    public class VideoPreviewCreator : IFilePreviewCreator
    {
        private readonly Guid _uid = new Guid("{2B94E4DF-BCE2-4b54-AC85-3ABE24BB5F92}");

        public Guid Uid
        {
            get { return _uid; }
        }

        public string DisplayName
        {
            get { return SR.T("Видео файлы (.mp4)"); }
        }

        public List<string> Extensions
        {
            get { return new List<string> { ".mp4" }; }
        }

        public string GetMainFileName(BinaryFile file)
        {
            return file.ContentFilePath;
        }

        public void Create(string path, BinaryFile file)
        {

        }

        public string GetPreviewText(BinaryFile file)
        {
            return null;
        }

        public bool EnableGenerateHtml()
        {
            return false;
        }

        public IRuntimeApplication RuntimeApplication { get; set; }

        public string PreviewDir
        {
            get { return null; }
        }

        public string GetRelativeMainFileName(BinaryFile file)
        {
            return null;
        }

        public virtual string GetTextFileName(string filePreviewDir, BinaryFile file)
        {
            return null;
        }

        public virtual string GetTextFileName(BinaryFile file)
        {
            return null;
        }

        public virtual string GetMainFileName(string filePreviewDir, BinaryFile file)
        {
            return GetTextFileName(filePreviewDir, file);
        }

        public virtual bool IsAvaliable(BinaryFile file)
        {
            var settings = Locator.GetService<PreviewSettingsModule>();
            return settings == null || settings.IsEnabledPreview(this);
        }

        public virtual bool HasPreview(BinaryFile file)
        {
            return HasPreview(file, 5);
        }

        public virtual bool HasPreview(BinaryFile file, long priority)
        {
            return true;
        }

        protected virtual Encoding GetFileEncoding(string filename)
        {
            var fileContent = File.ReadAllBytes(filename);
            return EncodingTools.DetectInputCodepage(fileContent);
        }

    }
}