﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EleWise.ELMA;
using EleWise.ELMA.ComponentModel;
using EleWise.ELMA.Files;
using EleWise.ELMA.Security;
using EleWise.ELMA.Security.Services;
using EleWise.ELMA.Services;

namespace VersionExtendedFilePermission.Permissions
{
    [Component]
    public class VersionExtendedFilePermission : IExtendedFilePermissionValidator
    {
        public bool HasPermission(BinaryFile file, out string errorMessage)
        {
            errorMessage = string.Empty;
            var res = Locator.GetServiceNotNull<ISecurityService>().HasPermission(CommonPermissions.AdminPermission);
            if (!res)
                errorMessage = SR.T("Недостаточно прав доступа к версии файла");
            return res;
        }
    }
}
