﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using EleWise.ELMA;
using EleWise.ELMA.Model.Attributes;
using EleWise.ELMA.Runtime.Settings;

namespace SimplePermissions.Web.Extensions
{
    public class Settings : GlobalSettingsBase
    {
        /// <summary>
        /// Определяет, что пароль не изменен
        /// </summary>
        public const string PASSWORD_NOT_CHANGED = "($PASSWORD_NOT_CHANGED$)";

        public Settings()
        {
            DataSource = "(local)";
            InitialCatalog = "BASEMESSAGES";
        }


        [DisplayName(typeof(@__Resources_MSSQLConnectionSettings), "DataSource")]
        [Description(typeof(@__Resources_MSSQLConnectionSettings), "DataSourceDescription")]
        [Required(true)] //Обязательность заполнения поля
        public string DataSource { get; set; }

        [DisplayName(typeof(@__Resources_MSSQLConnectionSettings), "InitialCatalog")]
        [Description(typeof(@__Resources_MSSQLConnectionSettings), "InitialCatalogDescription")]
        [Required(true)] //Обязательность заполнения поля
        public string InitialCatalog { get; set; }

        [DisplayName(typeof(@__Resources_MSSQLConnectionSettings), "UserId")]
        [Description(typeof(@__Resources_MSSQLConnectionSettings), "UserIdDescription")]
        [Required(true)] //Обязательность заполнения поля
        public string UserId { get; set; }
        
        private string _serverPassword;
    }

    /// <summary>
    /// Ресурсы
    /// </summary>
    internal class @__Resources_MSSQLConnectionSettings
    {
        public static string DataSource { get { return SR.T("DataSource"); } }

        public static string DataSourceDescription { get { return SR.T("Коннект до базы"); } }

        public static string InitialCatalog { get { return SR.T("InitialCatalog"); } }

        public static string InitialCatalogDescription { get { return SR.T("Имя базы данных"); } }

        public static string UserId { get { return SR.T("Имя пользователя"); } }

        public static string UserIdDescription { get { return SR.T("Имя пользователя для подключения к БД"); } }
        
    }
}