﻿using System;
using System.Collections.Generic;
using System.IO;
using System.IO.IsolatedStorage;
using System.Linq;
using System.Net;
using System.Runtime.Serialization.Json;
using System.Text;
using System.Windows;
using System.Windows.Browser;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Markup;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Media.Imaging;
using System.Windows.Resources;
using System.Windows.Shapes;
using System.Xml.Linq;
using Telerik.Windows.Controls;
using ImageTools.IO;
using ImageTools.IO.Jpeg;
using ImageTools.IO.Png;
using ImageTools;

namespace IMS
{
    public partial class MainPage : UserControl
    {
        string[] Cities = new string[] { "Казань", "Москва", "Нижний Новгород", "Пермь", "Самара", "Санкт-Петербург", "Тольятти", };
        string GorodString = null;
        string[] Formats = new string[] { "Стикер на дверях лифта", "на панелях управления в лифтах", "А-6", "А-5", "А5+А6", "А4 Гор", "А-4", "А3 Гор", "А-3", "А-3 Вер", "А-2", "А2 Гор", "А-1" };
        string PolosaString = "Полоса";
        ChildWindow1 cwNewProc = new ChildWindow1();
        ChildWindowPreBron cwPreBron = new ChildWindowPreBron();
        ChildWindow2 cwProdano = new ChildWindow2();
        ChildWindow3 cwLogin = new ChildWindow3();
        ChildWindowPicture cwPicture = new ChildWindowPicture();
        ChildWindowWaiting cwWaiting = new ChildWindowWaiting();

        string xmlPeriods;
        string xmlDistricts;
        string xmlTip;
        string xmlBron;
        string xmlRazm = "";
        string xmlRazmFilter = "";
        string xmlUser;
        // получить связть с веб-сервером
        WebServiceProxy.ProcessParamManagerSoapClient processMgrSoapClient =
            new IMS.WebServiceProxy.ProcessParamManagerSoapClient();

        StackPanel spOblast;
        StringBuilder sbTemplate = new StringBuilder();
        StringBuilder sbTemplate1 = new StringBuilder();
        StringBuilder sbTemplate2 = new StringBuilder();
        StringBuilder sbTemplate3 = new StringBuilder();
        StringBuilder sbTemplateCur = new StringBuilder();

        Button[, ,] buttonStend = new Button[50, 200, 200]; // первый индекс - номер района, второй - Y, третий - X
        Button[] buttonPolosa = new Button[50];
        Button[] butConform = new Button[50];
        StackPanel panelMain = new StackPanel();
        RadComboBox rcbGorod = new RadComboBox();
        StackPanel TopSP = new StackPanel();
        StackPanel spGorod = new StackPanel();
        ControlTemplate ctDefault;
        public const int PREBRON = 2;
        public const int PREBRON_ADMIN = 4;
        BronShort currentBron = null;
        bool isFirstLoaded = true;

        public class ResponseAuth
        {
            public string AuthToken;
            public string CurrentUserId;
            public string SessionToken;
        }

        ResponseAuth CurrentUser;
        string UserFullName;
        bool isAdmin = false;
        bool isROP = false;
        string ApplicationToken = "";
        string HostElma = "http://94.180.249.146:8000/";
        const double ButtonWidth = 78.75;
        const double ButtonHeight = 111;
        const double ButtonWidthHor = 157.5;
        const double ButtonHeightHor = 55.5;
        double ButtonWidthCur = ButtonWidth;
        double ButtonHeightCur = ButtonHeight;
        string infoBronString = "";
        RadContextMenu contextMenuButton = new RadContextMenu();
        Queue<Button> queuePicture = new Queue<Button>();



        public MainPage()
        {
            InitializeComponent();
            Loaded += MainPage_Loaded;

            LayoutRoot.Children.Add(TopSP);
        }
        private void MainPage_Loaded(object sender, RoutedEventArgs e)
        {
            Decoders.AddDecoder<PngDecoder>();
            Decoders.AddDecoder<JpegDecoder>();
            RadMenuItem menuItem = new RadMenuItem();
            menuItem.Header = "Картинка макета";
            menuItem.Click += menuItem_Click;
            contextMenuButton.Items.Add(menuItem);

            processMgrSoapClient.GetHostCompleted += new EventHandler<IMS.WebServiceProxy.GetHostCompletedEventArgs>(processMgrSoapClient_GetHostCompleted);
            processMgrSoapClient.GetHostAsync();
        }

        void menuItem_Click(object sender, Telerik.Windows.RadRoutedEventArgs e)
        {
            Button b = contextMenuButton.GetClickedElement<Button>();
            cwPicture.image.SetValue(Image.SourceProperty, (b.Tag as ButtonStruct).image);
            cwPicture.Show();

        }
        /// <summary>
        /// To set the cookie
        /// </summary>
        /// <param name="key">The key.
        /// <param name="value">The value.
        private void SetCookie(string key, string value)
        {

            // Expire in 1 year
            DateTime expireTime = DateTime.Now + TimeSpan.FromDays(365);

            string setCookie = key + "=" + value + ";expires=" + expireTime.ToString("R");
            HtmlPage.Document.SetProperty("cookie", setCookie);
            string[] getcookies = HtmlPage.Document.Cookies.Split(';');

        }

        private void saveImage(string key, string value)
        {
            try
            {
                using (IsolatedStorageFile isoFile = IsolatedStorageFile.GetUserStoreForApplication())
                {
                    using (IsolatedStorageFileStream isoStream =
                    new IsolatedStorageFileStream(key, FileMode.Create, isoFile))
                    {
                        Int64 freeSpace = isoFile.AvailableFreeSpace;
                        Int64 needSpace = value.Length * 10;
                        if (freeSpace < needSpace)
                        {
                            if (!isoFile.IncreaseQuotaTo(isoFile.Quota + needSpace))
                            {
                                // MessageBox.Show("User rejected increase space request");
                            }
                            else
                            {
                            }
                        }

                        using (StreamWriter sw = new StreamWriter(isoStream))
                        {
                            sw.Write(value);
                        }
                    }
                }
            }
            catch (Exception ex) { }
        }

        private string loadImage(string key)
        {
            try
            {
                using (IsolatedStorageFile isoFile = IsolatedStorageFile.GetUserStoreForApplication())
                {
                    using (IsolatedStorageFileStream isoStream =
                    new IsolatedStorageFileStream(key, FileMode.OpenOrCreate, isoFile))
                    {
                        using (StreamReader sw = new StreamReader(isoStream))
                        {
                            return sw.ReadToEnd();
                        }
                    }
                }
            }
            catch { return string.Empty; }
        }

        /// <summary>
        /// Gets the cookie.
        /// </summary>
        /// <param name="key">The key.
        /// <returns>cookie stored</returns>
        private string GetMyCookie(string key)
        {
            string[] getcookies = HtmlPage.Document.Cookies.Split(';');

            foreach (string mycookie in getcookies)
            {
                string[] mykeyValue = mycookie.Split('=');
                if (mykeyValue.Length == 2)
                {
                    if (mykeyValue[0].ToString().Trim() == key)
                        return mykeyValue[1];
                }
            }
            return "";

        }

        void cwLogin_Closed(object sender, EventArgs e)
        {
            if (cwLogin.DialogResult == false)
                return;
            string login = cwLogin.Login.Text;
            string password = cwLogin.Password.Password;
            SetCookie("Login", login);
            SetCookie("PIMS", password);
            WebClient wc = new WebClient();
            wc.UploadStringCompleted += wc_UploadStringCompleted;
            // получить соединение с элмой
            Uri serviceUri = new Uri(HostElma + "API/REST/Authorization/LoginWith?username=" + login);
            wc.Headers["ApplicationToken"] = ApplicationToken;
            wc.Headers["Content-Type"] = "application/json";
            wc.UploadStringAsync(serviceUri, "POST", string.Format("\"{0}\"", password));
        }

        void startProcess(string id, string name)
        {
            /*
            WebClient wc = new WebClient();
            wc.OpenReadCompleted += wc_OpenReadCompleted;
            wc.UploadStringCompleted += wc_UploadStringCompleted1;
            // запустить процесс
            Uri serviceUri = new Uri(HostElma+"Processes/ProcessHeader/RunByWebQuery/1558816d-5b80-4193-8523-7a4e12b4910e?IdBron="+id+"&ProcessName="+name);
            //wc.Headers["ApplicationToken"] = ApplicationToken;
            //wc.Headers["AuthToken"] = CurrentUser.AuthToken;
            //wc.Headers["Content-Type"] = "application/json";

            StreamResourceInfo sri = Application.GetResourceStream(new Uri("TextFile1.txt", UriKind.Relative));
            using (TextReader tr = new StreamReader(sri.Stream))
            {
                sf = tr.ReadToEnd();
            }
            //string.Format(sf,"test",id)
            //wc.UploadStringAsync(serviceUri, "GET"); 
            wc.OpenReadAsync(serviceUri);
            */
            HtmlPage.Window.Navigate(
                        new Uri(HostElma + "Processes/ProcessHeader/RunByWebQuery/1558816d-5b80-4193-8523-7a4e12b4910e?IdBron=" + id + "&ProcessName=" + name, UriKind.Absolute),
                        "_blank");
        }

        void wc_OpenReadCompleted(object sender, OpenReadCompletedEventArgs e)
        {
            if (e.Error == null)
            {
                Stream responseStream = e.Result;
            }
        }

        void wc_UploadStringCompleted1(object sender, UploadStringCompletedEventArgs e)
        {
            if (e.Error == null)
            {
                string s = e.Result;
            }
        }

        void wc_UploadStringCompleted(object sender, UploadStringCompletedEventArgs e)
        {
            if (e.Error == null)
            {
                string s = e.Result;
                DataContractJsonSerializer serializer = new DataContractJsonSerializer(typeof(ResponseAuth));
                MemoryStream stream = new MemoryStream();
                StreamWriter writer = new StreamWriter(stream);
                writer.Write(s);
                writer.Flush();
                stream.Position = 0;
                CurrentUser = (ResponseAuth)serializer.ReadObject(stream);
                // получение данных 
                LoadData(processMgrSoapClient);
                Visibility = Visibility.Visible;

            }
            else
            {
                MessageBox.Show(e.Error.Message);
                cwLogin.Show();
            }
        }

        private void ChangeFilter()
        {
            makeStend();
        }

        private void ChangedCity(object sender, Telerik.Windows.Controls.SelectionChangedEventArgs e)
        {
            queuePicture.Clear();
            // взять типы размещения
            processMgrSoapClient.RetrieveTipAsync(rcbGorod.SelectedIndex + 1);
        }

        void LoadData(WebServiceProxy.ProcessParamManagerSoapClient processMgrSoapClient)
        {
            spGorod.Orientation = Orientation.Horizontal;
            TextBlock tb = new TextBlock();
            tb.Text = "Город:";
            tb.Width = 70;
            spGorod.Children.Add(tb);

            rcbGorod.Width = 230;
            rcbGorod.FontSize = 20;
            spGorod.Children.Add(rcbGorod);

            foreach (var item in Cities)
                rcbGorod.Items.Add(item);

            sbTemplate.Append("<ControlTemplate xmlns='http://schemas.microsoft.com/winfx/2006/xaml/presentation' xmlns:x='http://schemas.microsoft.com/winfx/2006/xaml' ");
            sbTemplate.Append("xmlns:data='clr-namespace:System.Windows.Controls;assembly=System.Windows.Controls.Data' xmlns:mc='http://schemas.openxmlformats.org/markup-compatibility/2006' ");
            sbTemplate.Append("TargetType='Button' >");
            sbTemplate.Append("<Border x:Name=\"Border\" Background=\"#effab62d\" ><ContentPresenter VerticalAlignment=\"Center\" HorizontalAlignment=\"Center\" /></Border> ");
            sbTemplate.Append("</ControlTemplate> ");

            sbTemplate1.Append("<ControlTemplate xmlns='http://schemas.microsoft.com/winfx/2006/xaml/presentation' xmlns:x='http://schemas.microsoft.com/winfx/2006/xaml' ");
            sbTemplate1.Append("xmlns:data='clr-namespace:System.Windows.Controls;assembly=System.Windows.Controls.Data' xmlns:mc='http://schemas.openxmlformats.org/markup-compatibility/2006' ");
            sbTemplate1.Append("TargetType='Button' >");
            sbTemplate1.Append("<Border x:Name=\"Border\" Background=\"#efffb6c1\" ><ContentPresenter VerticalAlignment=\"Center\" HorizontalAlignment=\"Center\" /></Border> ");
            sbTemplate1.Append("</ControlTemplate> ");

            sbTemplate2.Append("<ControlTemplate xmlns='http://schemas.microsoft.com/winfx/2006/xaml/presentation' xmlns:x='http://schemas.microsoft.com/winfx/2006/xaml' ");
            sbTemplate2.Append("xmlns:data='clr-namespace:System.Windows.Controls;assembly=System.Windows.Controls.Data' xmlns:mc='http://schemas.openxmlformats.org/markup-compatibility/2006' ");
            sbTemplate2.Append("TargetType='Button' >");
            sbTemplate2.Append("<Border x:Name=\"Border\" Background=\"#ef964b00\" ><ContentPresenter VerticalAlignment=\"Center\" HorizontalAlignment=\"Center\" /></Border> ");
            sbTemplate2.Append("</ControlTemplate> ");

            sbTemplate3.Append("<ControlTemplate xmlns='http://schemas.microsoft.com/winfx/2006/xaml/presentation' xmlns:x='http://schemas.microsoft.com/winfx/2006/xaml' ");
            sbTemplate3.Append("xmlns:data='clr-namespace:System.Windows.Controls;assembly=System.Windows.Controls.Data' xmlns:mc='http://schemas.openxmlformats.org/markup-compatibility/2006' ");
            sbTemplate3.Append("TargetType='Button' >");
            sbTemplate3.Append("<Border x:Name=\"Border\" Background=\"#effad201\" ><ContentPresenter VerticalAlignment=\"Center\" HorizontalAlignment=\"Center\" /></Border> ");
            sbTemplate3.Append("</ControlTemplate> ");

            sbTemplateCur.Append("<ControlTemplate xmlns='http://schemas.microsoft.com/winfx/2006/xaml/presentation' xmlns:x='http://schemas.microsoft.com/winfx/2006/xaml' ");
            sbTemplateCur.Append("xmlns:data='clr-namespace:System.Windows.Controls;assembly=System.Windows.Controls.Data' xmlns:mc='http://schemas.openxmlformats.org/markup-compatibility/2006' ");
            sbTemplateCur.Append("TargetType='Button' >");
            sbTemplateCur.Append("<Border x:Name=\"Border\" Background=\"Green\" ><ContentPresenter VerticalAlignment=\"Center\" HorizontalAlignment=\"Center\" /></Border> ");
            sbTemplateCur.Append("</ControlTemplate> ");

            rcbGorod.SelectionChanged += ChangedCity;
            cwNewProc.Closed += cwNewProc_Closed;
            cwPreBron.Closed += cwPreBron_Closed;
            cwProdano.Closed += cwProdano_Closed;
            processMgrSoapClient.RetrieveProcessCompleted += new EventHandler<IMS.WebServiceProxy.RetrieveProcessCompletedEventArgs>(processMgrSoapClient_RetrieveProcessCompleted);
            processMgrSoapClient.RetrievePeriodCompleted += new EventHandler<IMS.WebServiceProxy.RetrievePeriodCompletedEventArgs>(processMgrSoapClient_RetrievePeriodCompleted);
            processMgrSoapClient.RetrieveDistrictCompleted += new EventHandler<IMS.WebServiceProxy.RetrieveDistrictCompletedEventArgs>(processMgrSoapClient_RetrieveDistrictCompleted);
            processMgrSoapClient.RetrieveTipCompleted += new EventHandler<IMS.WebServiceProxy.RetrieveTipCompletedEventArgs>(processMgrSoapClient_RetrieveTipCompleted);
            //processMgrSoapClient.RetrieveFormatCompleted += new EventHandler<IMS.WebServiceProxy.RetrieveFormatCompletedEventArgs>(processMgrSoapClient_RetrieveFormatCompleted);
            processMgrSoapClient.RetrieveBronCompleted += new EventHandler<IMS.WebServiceProxy.RetrieveBronCompletedEventArgs>(processMgrSoapClient_RetrieveBronCompleted);
            processMgrSoapClient.CreateProcessCompleted += new EventHandler<IMS.WebServiceProxy.CreateProcessCompletedEventArgs>(processMgrSoapClient_CreateProcessCompleted);
            processMgrSoapClient.UpdateProcessCompleted += new EventHandler<IMS.WebServiceProxy.UpdateProcessCompletedEventArgs>(processMgrSoapClient_UpdateProcessCompleted);
            processMgrSoapClient.UpdateRazmCompleted += new EventHandler<IMS.WebServiceProxy.UpdateRazmCompletedEventArgs>(processMgrSoapClient_UpdateRazmCompleted);
            processMgrSoapClient.RetrieveRazmCompleted += new EventHandler<IMS.WebServiceProxy.RetrieveRazmCompletedEventArgs>(processMgrSoapClient_RetrieveRazmCompleted);
            processMgrSoapClient.RetrieveRazmFilterCompleted += new EventHandler<IMS.WebServiceProxy.RetrieveRazmFilterCompletedEventArgs>(processMgrSoapClient_RetrieveRazmFilterCompleted);
            processMgrSoapClient.RetrieveUserCompleted += new EventHandler<IMS.WebServiceProxy.RetrieveUserCompletedEventArgs>(processMgrSoapClient_RetrieveUserCompleted);
            processMgrSoapClient.DeleteBronRazmCompleted += new EventHandler<IMS.WebServiceProxy.DeleteBronRazmCompletedEventArgs>(processMgrSoapClient_DeleteBronRazmCompleted);
            processMgrSoapClient.DeleteProcessCompleted += new EventHandler<IMS.WebServiceProxy.DeleteProcessCompletedEventArgs>(processMgrSoapClient_DeleteProcessCompleted);
            processMgrSoapClient.SetConformCompleted += new EventHandler<IMS.WebServiceProxy.SetConformCompletedEventArgs>(processMgrSoapClient_SetConformCompleted);
            processMgrSoapClient.GetPictureCompleted += new EventHandler<IMS.WebServiceProxy.GetPictureCompletedEventArgs>(processMgrSoapClient_GetPictureCompleted);
            processMgrSoapClient.UploadPictureCompleted += new EventHandler<IMS.WebServiceProxy.UploadPictureCompletedEventArgs>(processMgrSoapClient_UploadPictureCompleted);

            processMgrSoapClient.RetrieveUserAsync(CurrentUser.CurrentUserId);
        }

        void processMgrSoapClient_GetHostCompleted(object sender, IMS.WebServiceProxy.GetHostCompletedEventArgs e)
        {
            if (e.Error == null)
            {
                string xml = e.Result;
                ApplicationToken = XDocument.Parse(xml).Descendants("ApplicationToken").FirstOrDefault().Value;
                HostElma = XDocument.Parse(xml).Descendants("HostElma").FirstOrDefault().Value;
                Visibility = Visibility.Collapsed;
                cwLogin.Closed += cwLogin_Closed;
                // get cookies from browser
                cwLogin.Login.Text = GetMyCookie("Login");
                cwLogin.Password.Password = GetMyCookie("PIMS");
                cwLogin.Show();
            }
            else
                MessageBox.Show(e.Error.Message);

        }

        void processMgrSoapClient_DeleteBronRazmCompleted(object sender, IMS.WebServiceProxy.DeleteBronRazmCompletedEventArgs e)
        {
            if (e.Error == null)
            {
                processMgrSoapClient.RetrieveBronAsync(CurrentUser.CurrentUserId);
            }
            else
                MessageBox.Show(e.Error.Message);

        }

        public class ItemWebAPI
        {
            public ItemsWebAPI Data = null;
            public List<ItemsWebAPI> DataArray = new List<ItemsWebAPI>();
            public string Name;
            public string Value;
        }

        public class ItemsWebAPI
        {
            public List<ItemWebAPI> Items = new List<ItemWebAPI>();
        }

        public static byte[] ReadFully(Stream input, long length)
        {
            byte[] buffer = new byte[length];
            using (MemoryStream ms = new MemoryStream())
            {
                int read;
                while ((read = input.Read(buffer, 0, buffer.Length)) > 0)
                {
                    ms.Write(buffer, 0, read);
                }
                return ms.ToArray();
            }
        }
        
        void processMgrSoapClient_SetConformCompleted(object sender, IMS.WebServiceProxy.SetConformCompletedEventArgs e)
        {
            if (e.Error == null)
            {
                ExtendedImage extImage = bsSendTask.canvas.ToImage();
                PngEncoder pngCoder = new PngEncoder();
                MemoryStream pngStream = new MemoryStream();
                pngCoder.Encode(extImage, pngStream);
                processMgrSoapClient.UploadPictureAsync(pngStream.ToArray(), HostElma, ApplicationToken, CurrentUser.AuthToken);
                /*
                WebClient wc= new WebClient();
                wc.UploadStringCompleted += wc_UploadStringCompletedFile;
                Uri serviceUri = new Uri(HostElma + "API/REST/Files/Upload");
                wc.Headers["ApplicationToken"] = ApplicationToken;
                wc.Headers["AuthToken"] = CurrentUser.AuthToken;
                wc.Headers["Content-Type"] = "application/json";
                wc.Headers["FileName"] = "Stend.png";
                // сформировать картинку и послать её в элму в виде файла
                ExtendedImage extImage = bsSendTask.canvas.ToImage();
                PngEncoder pngCoder = new PngEncoder();
                MemoryStream pngStream = new MemoryStream();
                pngCoder.Encode(extImage, pngStream);
                pngStream.Position = 0;
                var sr = new StreamReader(pngStream);
                string text = sr.ReadToEnd();
                //byte[] buffer = pngStream.ToArray();
                //string text = Convert.ToBase64String(buffer);
                //string text = UTF8Encoding.UTF8.GetString(buffer, 0, buffer.Length);
                wc.UploadStringAsync(serviceUri, "POST", text);
                */

                /*
                WebClient wc = new WebClient();
                wc.OpenWriteCompleted += wc_UploadStringCompletedFile;
                Uri serviceUri = new Uri(HostElma + "API/REST/Files/Upload");
                wc.Headers["ApplicationToken"] = ApplicationToken;
                wc.Headers["AuthToken"] = CurrentUser.AuthToken;
                wc.Headers["Content-Type"] = "application/json";
                wc.Headers["FileName"] = "Stend.png";
                // сформировать картинку и послать её в элму в виде файла
                ExtendedImage extImage = bsSendTask.canvas.ToImage();
                PngEncoder pngCoder = new PngEncoder();
                MemoryStream pngStream = new MemoryStream();
                pngCoder.Encode(extImage, pngStream);
                // Do something with the value
                wc.OpenWriteAsync(serviceUri, "POST", pngStream);
                */
            }
            else
                MessageBox.Show(e.Error.Message);
        }

        string getDesignerId(string gorod)
        {
            //" 26, 73, 98, 27, 10, 26"+ // ид дизайнеров для задач после согласования 
            string DesignerPermId = "26";
            string DesignerNNId = "73";
            string DesignerSamaraId = "98";
            string DesignerSpbId = "27";//"27";
            string DesignerKazanId = "10";
            string DesignerTolId = "26";

            if (Cities[0] == gorod)
                return DesignerKazanId;
            if (Cities[1] == gorod)
                return DesignerKazanId;
            if (Cities[2] == gorod)
                return DesignerNNId;
            if (Cities[3] == gorod)
                return DesignerPermId;
            if (Cities[4] == gorod)
                return DesignerSamaraId;
            if (Cities[5] == gorod)
                return DesignerSpbId;
            if (Cities[6] == gorod)
                return DesignerTolId;
            return DesignerKazanId;
        }
        string makeItems(ItemsWebAPI item)
        {
            using (MemoryStream ms = new MemoryStream())
            {
                DataContractJsonSerializer serializer =
                        new DataContractJsonSerializer(item.GetType());
                serializer.WriteObject(ms, item);
                ms.Position = 0;

                using (StreamReader reader = new StreamReader(ms))
                {
                    return reader.ReadToEnd();
                }
            }
        }

        //void wc_UploadStringCompletedFile(object sender, OpenWriteCompletedEventArgs e)
        //void wc_UploadStringCompletedFile(object sender, UploadStringCompletedEventArgs e)
        void processMgrSoapClient_UploadPictureCompleted(object sender, IMS.WebServiceProxy.UploadPictureCompletedEventArgs e)
        {
            if (e.Error == null)
            {
                /*
                StreamReader reader = new StreamReader(e.Result);
                string UidFile = reader.ReadToEnd();
                */
                
                string UidFile = e.Result;
                
                UidFile = UidFile.Remove(0, 1);
                UidFile = UidFile.Remove(UidFile.Length - 1);
                UidFile = HttpUtility.UrlEncode(UidFile);
                

                // Послать задачу менеджеру 
                WebClient wc = new WebClient();
                wc.UploadStringCompleted += wc_UploadStringCompletedTask;
                // получить соединение с элмой
                Uri serviceUri = new Uri(HostElma + "API/REST/Tasks/Create");
                wc.Headers["ApplicationToken"] = ApplicationToken;
                wc.Headers["AuthToken"] = CurrentUser.AuthToken;
                wc.Headers["Content-Type"] = "application/json";
                ItemsWebAPI items = new ItemsWebAPI();
                ItemWebAPI item = new ItemWebAPI();
                item.Name = "Subject";
                item.Value = "Стенд согласован";
                items.Items.Add(item);

                item = new ItemWebAPI();
                ItemsWebAPI itemExecutor = new ItemsWebAPI();
                itemExecutor.Items.Add(new ItemWebAPI());
                itemExecutor.Items[0].Name = "Id";
                itemExecutor.Items[0].Value = getDesignerId(rcbGorod.SelectedValue.ToString());
                item.Data = itemExecutor;

                item.Name = "Executor";
                item.Value = null;
                items.Items.Add(item);

                item = new ItemWebAPI();
                List<ItemsWebAPI> itemAttachs = new List<ItemsWebAPI>();
                ItemsWebAPI itemAttach = new ItemsWebAPI();

                ItemsWebAPI itemUid = new ItemsWebAPI();
                itemUid.Items.Add(new ItemWebAPI());
                itemUid.Items[0].Name = "Uid";
                itemUid.Items[0].Value = UidFile;
                ItemWebAPI itemFile = new ItemWebAPI();
                itemFile.Data = itemUid;
                itemFile.Name = "File";
                itemFile.Value = null;
                itemAttach.Items.Add(itemFile);

                itemAttachs.Add(itemAttach);
                item.DataArray = itemAttachs;
                item.Name = "Attachments";
                item.Value = null;
                items.Items.Add(item);


                item = new ItemWebAPI();
                item.Name = "StartDate";
                item.Value = DateTime.Now.ToString();
                items.Items.Add(item);
                item = new ItemWebAPI();
                item.Name = "EndDate";
                item.Value = DateTime.Now.AddDays(1).ToString();
                items.Items.Add(item);
                item = new ItemWebAPI();
                item.Name = "Description";
                item.Value = "Задача создана РОП (" + rcbGorod.SelectedValue.ToString() + ") после согласования стенда по району " + bsSendTask.Rayon;
                items.Items.Add(item);

                string s = makeItems(items);
                wc.UploadStringAsync(serviceUri, "POST", s);

            }
        }

        void wc_UploadStringCompletedTask(object sender, UploadStringCompletedEventArgs e)
        {
            if (e.Error == null)
            {
                string s = e.Result;
                conformButton.IsEnabled = false;
                conformButton = null;
            }
        }


        void processMgrSoapClient_GetPictureCompleted(object sender, IMS.WebServiceProxy.GetPictureCompletedEventArgs e)
        {
            if (e.Error == null)
            {
                string imageName = e.imageName;
                byte[] image = e.image;
                string imageStr = "";
                ButtonStruct bs;
                Button b;
                if (image != null)
                {
                    imageStr = Convert.ToBase64String(image);
                    if (image.Length == 0)
                    {
                        imageStr = loadImage(imageName);
                        image = Convert.FromBase64String(imageStr);
                    }
                    else
                    {
                        imageStr = Convert.ToBase64String(image);
                        saveImage(imageName, imageStr);
                    }

                    if (queuePicture.Count == 0)
                        return;
                    b = queuePicture.Peek();
                    bs = b.Tag as ButtonStruct;
                    setImage(image, out bs.image);
                    FillButton(b);
                }
                if (queuePicture.Count == 0)
                    return;
                queuePicture.Dequeue();
                if (queuePicture.Count > 0)
                {
                    b = queuePicture.Peek();
                    bs = b.Tag as ButtonStruct;
                    processMgrSoapClient.GetPictureAsync(bs.imageName, bs.imageStr.Length);
                }

            }
            else
                MessageBox.Show(e.Error.Message);

        }

        void processMgrSoapClient_DeleteProcessCompleted(object sender, IMS.WebServiceProxy.DeleteProcessCompletedEventArgs e)
        {
            if (e.Error == null)
            {
                processMgrSoapClient.DeleteBronRazmAsync(currentBron.Id.ToString());
            }
            else
                MessageBox.Show(e.Error.Message);

        }

        void processMgrSoapClient_RetrieveUserCompleted(object sender, IMS.WebServiceProxy.RetrieveUserCompletedEventArgs e)
        {
            if (e.Error == null)
            {
                xmlUser = e.Result;
                UserFullName = XDocument.Parse(xmlUser).Descendants("FullName").FirstOrDefault().Value;
                GorodString = XDocument.Parse(xmlUser).Descendants("Gorod").FirstOrDefault().Value;
                isAdmin = bool.Parse(XDocument.Parse(xmlUser).Descendants("IsAdmin").FirstOrDefault().Value);
                isROP = bool.Parse(XDocument.Parse(xmlUser).Descendants("IsROP").FirstOrDefault().Value);

                if (isAdmin)
                    rcbGorod.IsEnabled = true;
                else
                    rcbGorod.IsEnabled = false;
                processMgrSoapClient.RetrievePeriodAsync(isAdmin);
                //startProcess("18","test"); // test
            }
            else
                MessageBox.Show(e.Error.Message);

        }

        void processMgrSoapClient_RetrieveRazmFilterCompleted(object sender, IMS.WebServiceProxy.RetrieveRazmFilterCompletedEventArgs e)
        {
            cwWaiting.Close();
            if (e.Error == null)
            {
                xmlRazmFilter = e.Result;
                // показать всю бронь на стенде
                FillBron(xmlRazmFilter, false);
                // показать текущую бронь
                FillBron(xmlRazm, true);
                isFirstLoaded = false;
                cwPreBron.TextBox2.Text = infoBronString;
                cwProdano.TextBox2.Text = infoBronString;

                if (queuePicture.Count > 0)
                {
                    Button b = queuePicture.Peek();
                    ButtonStruct bs = b.Tag as ButtonStruct;
                    processMgrSoapClient.GetPictureAsync(bs.imageName, bs.imageStr.Length);
                }
            }
            else
                MessageBox.Show(e.Error.Message);

        }

        void processMgrSoapClient_RetrieveRazmCompleted(object sender, IMS.WebServiceProxy.RetrieveRazmCompletedEventArgs e)
        {
            if (e.Error == null)
            {
                xmlRazm = e.Result;
                // сбросить кнопки
                int z1 = 0;
                foreach (var item3 in XDocument.Parse(xmlDistricts).Root.Elements())
                {
                    int X, Y;
                    bool isA6Hor;
                    int.TryParse(item3.Descendants("X").FirstOrDefault().Value, out X);
                    int.TryParse(item3.Descendants("Y").FirstOrDefault().Value, out Y);
                    bool.TryParse(item3.Descendants("IsA6Hor").FirstOrDefault().Value, out isA6Hor);
                    string rayon = item3.Descendants("Rayony").FirstOrDefault().Value;
                    Button b;
                    // сбросить все кнопки на стендах
                    for (int i = 0; i < Y; i++)
                    {
                        for (int j = 0; j < X; j++)
                        {
                            b = buttonStend[z1, i, j];
                            b.Tag = new ButtonStruct();
                            (b.Tag as ButtonStruct).X = j;
                            (b.Tag as ButtonStruct).Y = i;
                            (b.Tag as ButtonStruct).Z = z1;
                            (b.Tag as ButtonStruct).MaxX = X;
                            (b.Tag as ButtonStruct).MaxY = Y;
                            (b.Tag as ButtonStruct).Rayon = rayon;
                            (b.Tag as ButtonStruct).isCurrentProcess = false;
                            (b.Tag as ButtonStruct).isA6Hor = isA6Hor;
                            (b.Tag as ButtonStruct).ChoiceButton = 1;
                            FillButton(b);
                        }
                    }
                    // инициализировать полосу
                    b = buttonPolosa[z1];
                    b.Tag = new ButtonStruct();
                    (b.Tag as ButtonStruct).X = -1;
                    (b.Tag as ButtonStruct).Y = -1;
                    (b.Tag as ButtonStruct).Z = z1;
                    (b.Tag as ButtonStruct).MaxX = X;
                    (b.Tag as ButtonStruct).MaxY = Y;
                    (b.Tag as ButtonStruct).Rayon = rayon;
                    (b.Tag as ButtonStruct).isCurrentProcess = false;
                    (b.Tag as ButtonStruct).isA6Hor = isA6Hor;
                    (b.Tag as ButtonStruct).ChoiceButton = 1;
                    (b.Tag as ButtonStruct).isPolosa = true;
                    FillButton(b);
                    z1++;
                }
                cwWaiting.Show();
                processMgrSoapClient.RetrieveRazmFilterAsync(rcbGorod.SelectedValue.ToString(), (rcbPeriod.SelectedValue as PeriodShort).Id.ToString(), rcbTip.SelectedValue.ToString());
            }
            else
                MessageBox.Show(e.Error.Message);
        }

        void FillBron(string xmlString, bool isCurrent)
        {
            if (xmlString.Length == 0)
                return;
            if (isCurrent)
                infoBronString = currentBron.Name + "\n";
            int countInfo = 1;
            queuePicture.Clear();
            foreach (var item1 in XDocument.Parse(xmlString).Root.Elements())
            {
                string markStend = item1.Descendants("MarkStend").FirstOrDefault().ToString();
                string period = item1.Descendants("Period").FirstOrDefault().Value;
                string periodName = item1.Descendants("PeriodName").FirstOrDefault().Value;
                string tip = item1.Descendants("Tip").FirstOrDefault().Value;
                string format = item1.Descendants("Format").FirstOrDefault().Value;
                string rayon = item1.Descendants("Rayon").FirstOrDefault().Value;
                if (isCurrent)
                {
                    infoBronString += countInfo + " " + "–––––––––––––––––––––––––––––––––––––––––––––\n";
                    infoBronString += periodName + ":" + format + ":" + rayon + ":" + "\n";
                    infoBronString += tip + "\n";
                }
                countInfo++;
                if (period != (rcbPeriod.SelectedValue as PeriodShort).Id.ToString())
                    continue;
                if (tip != (rcbTip.SelectedValue).ToString())
                    continue;
                foreach (var item2 in XDocument.Parse(markStend).Root.Elements())
                {
                    int z = 0;
                    Button b;
                    ButtonStruct bs;
                    foreach (var item3 in XDocument.Parse(xmlDistricts).Root.Elements())
                    {
                        if (item3.Descendants("Rayony").FirstOrDefault().Value ==
                            item1.Descendants("Rayon").FirstOrDefault().Value && format != PolosaString)
                        {
                            string stend = item1.Descendants("Stend").FirstOrDefault().ToString();
                            bool isFirst = true;
                            foreach (var item4 in XDocument.Parse(stend).Root.Elements())
                            {
                                int X, Y;
                                int.TryParse(item4.Descendants("X").FirstOrDefault().Value, out X);
                                int.TryParse(item4.Descendants("Y").FirstOrDefault().Value, out Y);
                                b = buttonStend[z, Y, X];
                                if (b == null) // X или Y не попадает в отведенный размер
                                    continue;
                                bs = (b.Tag as ButtonStruct);
                                string tipBroni = item1.Descendants("TipBroni").FirstOrDefault().Value;
                                bs.userFIO = item1.Descendants("UserFIO").FirstOrDefault().Value;
                                bs.createdDate = item1.Descendants("CreatedDate").FirstOrDefault().Value;
                                bool.TryParse(item1.Descendants("IsConform").FirstOrDefault().Value, out bs.isConform);
                                if (bs.isConform == true)
                                {
                                    butConform[z].IsEnabled = false;
                                    // b.IsEnabled = false;
                                }
                                if (tipBroni == "0")
                                    bs.ChoiceButton = 2;
                                if (tipBroni == "1")
                                    bs.ChoiceButton = 3;
                                if (tipBroni == "2")
                                    bs.ChoiceButton = 4;
                                if (tipBroni == "3")
                                    bs.ChoiceButton = 5;
                                bs.idRazm = null;
                                bs.idRazmFilter = null;
                                bs.parent = item1.Descendants("Parent").FirstOrDefault().Value;
                                bs.idChild = item1.Descendants("ID").FirstOrDefault().Value;
                                bs.format = item1.Descendants("Format").FirstOrDefault().Value;
                                bs.BronName = item1.Descendants("BronName").FirstOrDefault().Value;
                                bs.isCurrentProcess = isCurrent;

                                if (isCurrent)
                                    b.ClickMode = ClickMode.Press;
                                if (isFirst && isCurrent)
                                    bs.idRazm = item1.Descendants("ID").FirstOrDefault().Value;
                                if (isFirst)
                                {
                                    bs.idRazmFilter = item1.Descendants("ID").FirstOrDefault().Value;
                                    bs.imageName = item1.Descendants("ImageName").FirstOrDefault().Value;
                                    if (bs.imageName != "")
                                    {
                                        getImage(bs.imageName, out bs.image, out bs.imageStr);
                                        queuePicture.Enqueue(b);
                                    }
                                }
                                setSizePositionButton(ref b, 1, 1);

                                int pr = getIndexFormat(bs.format);
                                if (pr != -1)
                                {
                                    int xx, yy;
                                    choiceFormat(pr, bs.isA6Hor, out xx, out yy);
                                    //b.SetValue(Grid.RowSpanProperty, 1);
                                    //b.SetValue(Grid.ColumnSpanProperty, 1);
                                    setSizePositionButton(ref b, 1, 1);
                                    // Установить размер левой верхней кнопки по формату для не выбранных форматов
                                    if (!isCurrent)
                                    {
                                        if (bs.idRazmFilter != null)
                                        {
                                            //b.SetValue(Grid.RowSpanProperty, yy);
                                            //b.SetValue(Grid.ColumnSpanProperty, xx);
                                            setSizePositionButton(ref b, xx, yy);
                                        }
                                    }
                                    else
                                        b.Visibility = System.Windows.Visibility.Visible;
                                }

                                isFirst = false;
                                FillButton(buttonStend[z, Y, X]);
                            }
                        }

                        // полоса
                        if (item1.Descendants("Format").FirstOrDefault().Value == PolosaString)
                            if (item3.Descendants("Rayony").FirstOrDefault().Value ==
                                item1.Descendants("Rayon").FirstOrDefault().Value)
                            {
                                b = buttonPolosa[z];
                                bs = (b.Tag as ButtonStruct);
                                string tipBroni = item1.Descendants("TipBroni").FirstOrDefault().Value;
                                bs.userFIO = item1.Descendants("UserFIO").FirstOrDefault().Value;
                                bs.createdDate = item1.Descendants("CreatedDate").FirstOrDefault().Value;
                                if (tipBroni == "0")
                                    bs.ChoiceButton = 2;
                                if (tipBroni == "1")
                                    bs.ChoiceButton = 3;
                                if (tipBroni == "2")
                                    bs.ChoiceButton = 4;
                                if (tipBroni == "3")
                                    bs.ChoiceButton = 5;
                                bs.idRazm = null;
                                bs.idRazmFilter = null;
                                if (isCurrent)
                                    bs.idRazm = item1.Descendants("ID").FirstOrDefault().Value;

                                bs.idRazmFilter = item1.Descendants("ID").FirstOrDefault().Value;
                                bs.imageName = item1.Descendants("ImageName").FirstOrDefault().Value;
                                if (bs.imageName != "")
                                {
                                    getImage(bs.imageName, out bs.image, out bs.imageStr);
                                    queuePicture.Enqueue(b);
                                }
                                bs.isCurrentProcess = isCurrent;
                                bs.format = item1.Descendants("Format").FirstOrDefault().Value;
                                bs.idChild = item1.Descendants("ID").FirstOrDefault().Value;
                                bs.BronName = item1.Descendants("BronName").FirstOrDefault().Value;
                                FillButton(b);
                            }
                        z++;
                    }
                }
            }
            if (isCurrent)
            {
                tbInfo.Text = infoBronString;
            }
        }

        void getImage(string imageName, out BitmapImage image, out string imageStr)
        {
            image = null;
            imageStr = null;
            if (imageName == "")
                return;
            imageStr = loadImage(imageName);
        }

        void setImage(byte[] imageBytes, out BitmapImage image)
        {
            image = null;
            if (imageBytes.Length != 0)
            {
                image = new BitmapImage();
                using (MemoryStream ms = new MemoryStream(imageBytes, 0,
                  imageBytes.Length))
                {
                    BitmapImage im = new BitmapImage();
                    im.SetSource(ms);
                    image = im;
                }
            }
        }

        int getIndexFormat(string format)
        {
            for (int pr = 0; pr < Formats.Length; pr++)
            {
                if (Formats[pr] == format)
                {
                    return pr;
                }
            }
            return -1;
        }

        void SetVisibleChildCells(Button b, int xx, int yy, Visibility v)
        {
            int z = (b.Tag as ButtonStruct).Z;
            int y = (b.Tag as ButtonStruct).Y;
            int x = (b.Tag as ButtonStruct).X;
            for (int i = y; i < y + yy; i++)
                for (int j = x; j < x + xx; j++)
                {
                    Button bCur = buttonStend[z, i, j];
                    if (bCur == null)
                        continue;
                    if (i > y || j > x)
                    {
                        if ((bCur.Tag as ButtonStruct).isKarman == false)
                            bCur.Visibility = v;
                        else
                            break;
                        if (v == Visibility.Visible)
                        {
                            if ((bCur.Tag as ButtonStruct).idRazmFilter == null)
                            {
                                (bCur.Tag as ButtonStruct).ChoiceButton = 1;
                                (bCur.Tag as ButtonStruct).format = null;
                                (bCur.Tag as ButtonStruct).idChild = null;
                                FillButton(bCur);
                            }
                        }
                        else
                        {
                            (bCur.Tag as ButtonStruct).ChoiceButton = (b.Tag as ButtonStruct).ChoiceButton;
                            (bCur.Tag as ButtonStruct).format = (b.Tag as ButtonStruct).format;
                            (bCur.Tag as ButtonStruct).idChild = (b.Tag as ButtonStruct).idChild;
                        }
                    }
                }
        }

        void setSizePositionButton(ref Button b, int xx, int yy)
        {
            if (!(b.Tag as ButtonStruct).isA6Hor)
            {
                b.Width = ButtonWidth * xx;
                b.Height = ButtonHeight * yy;
            }
            else
            {
                b.Width = ButtonWidthHor * xx;
                b.Height = ButtonHeightHor * yy;
            }

            ButtonStruct bs = b.Tag as ButtonStruct;
            if (!bs.isCurrentProcess)
                SetVisibleChildCells(b, xx, yy, System.Windows.Visibility.Collapsed);

            double newTop = bs.Y * ButtonHeightCur;
            double newLeft = bs.X * ButtonWidthCur;
            b.SetValue(Canvas.TopProperty, newTop);
            b.SetValue(Canvas.LeftProperty, newLeft);

        }

        void processMgrSoapClient_UpdateRazmCompleted(object sender, IMS.WebServiceProxy.UpdateRazmCompletedEventArgs e)
        {
            if (e.Error == null)
            {
                xmlRazm = "";
                cwWaiting.Show();
                processMgrSoapClient.RetrieveRazmFilterAsync(rcbGorod.SelectedValue.ToString(), (rcbPeriod.SelectedValue as PeriodShort).Id.ToString(), rcbTip.SelectedValue.ToString());
                lbBron1.SelectedItem = null;
                lbBron2.SelectedItem = null;
                lbBron3.SelectedItem = null;
            }
            else
                MessageBox.Show(e.Error.Message);
        }

        void ShowButton()
        {
            if (IsSaveButton == true)
            {
                bButton.Content = "Сохранить";
            }
            else
            {
                bButton.Content = "Забронировать";
            }
        }

        void processMgrSoapClient_CreateProcessCompleted(object sender, IMS.WebServiceProxy.CreateProcessCompletedEventArgs e)
        {
            if (e.Error == null)
            {
                processMgrSoapClient.RetrieveBronAsync(CurrentUser.CurrentUserId);
            }
            else
                MessageBox.Show(e.Error.Message);
        }

        void processMgrSoapClient_UpdateProcessCompleted(object sender, IMS.WebServiceProxy.UpdateProcessCompletedEventArgs e)
        {
            if (e.Error == null)
            {
                processMgrSoapClient.RetrieveBronAsync(CurrentUser.CurrentUserId);
            }
            else
                MessageBox.Show(e.Error.Message);
        }

        void processMgrSoapClient_RetrieveBronCompleted(object sender, IMS.WebServiceProxy.RetrieveBronCompletedEventArgs e)
        {
            if (e.Error == null)
            {
                xmlBron = e.Result;
                makeStend();
                lbBron1.Items.Clear();
                lbBron2.Items.Clear();
                lbBron3.Items.Clear();
                makeBronList("2");
                makeBronList("0");
                makeBronList("1");
                makeBronList("3");
                // спозиционировать бронь предварительную
                if (isNewBron)
                {
                    tabMain.SelectedIndex = 0;

                    // выбрать первую бронь из списка
                    if (tabMain.SelectedIndex == 0 && lbBron1.Items.Count > 0)
                    {
                        IsSaveButton = true;
                        ShowButton();
                        lbBron1.SelectedItem = lbBron1.Items[0];
                        processMgrSoapClient.RetrieveRazmAsync(currentBron.Id);
                    }
                    else if (tabMain.SelectedIndex == 1 && lbBron2.Items.Count > 0)
                    {
                        IsSaveButton = true;
                        ShowButton();
                        lbBron2.SelectedItem = lbBron2.Items[0];
                        processMgrSoapClient.RetrieveRazmAsync(currentBron.Id);
                    }
                    else if (tabMain.SelectedIndex == 2 && lbBron3.Items.Count > 0)
                    {
                        IsSaveButton = true;
                        ShowButton();
                        lbBron3.SelectedItem = lbBron3.Items[0];
                        processMgrSoapClient.RetrieveRazmAsync(currentBron.Id);
                    }
                }
                else
                {
                    xmlRazm = "";
                    cwWaiting.Show();
                    processMgrSoapClient.RetrieveRazmFilterAsync(rcbGorod.SelectedValue.ToString(), (rcbPeriod.SelectedValue as PeriodShort).Id.ToString(), rcbTip.SelectedValue.ToString());
                }
                if (lbBron1.SelectedItem == null && lbBron2.SelectedItem == null && lbBron3.SelectedItem == null)
                {
                    IsSaveButton = false;
                    ShowButton();
                }
                isNewBron = false;
            }
            else
                MessageBox.Show(e.Error.Message);
        }


        void processMgrSoapClient_RetrieveProcessCompleted(object sender, IMS.WebServiceProxy.RetrieveProcessCompletedEventArgs e)
        {
            if (e.Error == null)
            {
                MessageBox.Show(e.Result);
            }
            else
                MessageBox.Show(e.Error.Message);
        }

        void processMgrSoapClient_RetrieveDistrictCompleted(object sender, IMS.WebServiceProxy.RetrieveDistrictCompletedEventArgs e)
        {
            if (e.Error == null)
            {
                xmlDistricts = e.Result;
                makeStend();
                processMgrSoapClient.RetrieveBronAsync(CurrentUser.CurrentUserId);
            }
            else
                MessageBox.Show(e.Error.Message);
        }

        void processMgrSoapClient_RetrieveTipCompleted(object sender, IMS.WebServiceProxy.RetrieveTipCompletedEventArgs e)
        {
            if (e.Error == null)
            {
                xmlTip = e.Result;
                string tip = XDocument.Parse(xmlTip).Descendants("Tip").FirstOrDefault().Value;
                if (rcbTip != null)
                {
                    rcbTip.Items.Clear();
                    foreach (var item1 in XDocument.Parse(xmlTip).Root.Elements())
                    {
                        string s = item1.Descendants("Tip").FirstOrDefault().Value;
                        rcbTip.Items.Add(s);
                    }

                    if (rcbTip.Items.Count > 0)
                        rcbTip.SelectedItem = rcbTip.Items[0];

                }
                else
                {
                    // взять районы
                    processMgrSoapClient.RetrieveDistrictAsync(rcbGorod.SelectedIndex + 1, tip);
                }
            }
            else
                MessageBox.Show(e.Error.Message);
        }

        string makeXMLFilter()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
            sb.Append("<Filter>");
            sb.Append("<Gorod>");
            sb.Append(rcbGorod.SelectedValue.ToString());
            sb.Append("</Gorod>");
            sb.Append("<Period>");
            sb.Append(rcbPeriod.SelectedValue.ToString());
            sb.Append("</Period>");
            sb.Append("<District>");
            //sb.Append(rcbDistrict.SelectedValue.ToString());
            sb.Append("</District>");
            sb.Append("<Tip>");
            sb.Append(rcbTip.SelectedValue.ToString());
            sb.Append("</Tip>");
            sb.Append("</Filter>");

            return sb.ToString();
        }

        void processMgrSoapClient_RetrievePeriodCompleted(object sender, IMS.WebServiceProxy.RetrievePeriodCompletedEventArgs e)
        {
            if (e.Error == null)
            {
                xmlPeriods = e.Result;
                rcbGorod.SelectedValue = GorodString;
            }
            else
                MessageBox.Show(e.Error.Message);
        }

        StackPanel panelRight = new StackPanel();
        ScrollViewer svHor = new ScrollViewer();
        StackPanel spSaveDragDrop;
        void makeStend()
        {
            TopSP.Children.Clear();
            svHor.HorizontalScrollBarVisibility = ScrollBarVisibility.Auto;
            svHor.VerticalScrollBarVisibility = ScrollBarVisibility.Auto;
            panelMain.Children.Clear();

            TopSP.SetValue(Grid.RowProperty, 0);
            TopSP.Orientation = Orientation.Vertical;
            svHor.Content = panelMain;

            // панель для кнопок сохранения и отмены операций drag and drop
            spSaveDragDrop = new StackPanel();
            Button saveButDragAndDrop = new Button();
            Button cancelButDragAndDrop = new Button();
            saveButDragAndDrop.Click += saveButDragAndDrop_Click;
            cancelButDragAndDrop.Click += cancelButDragAndDrop_Click;
            spSaveDragDrop.Orientation = Orientation.Horizontal;
            spSaveDragDrop.Height = 50;
            TextBlock tb1 = new TextBlock();
            tb1.Text = "Сохранить перетаскивание";
            tb1.TextWrapping = TextWrapping.Wrap;
            saveButDragAndDrop.Content = tb1;
            saveButDragAndDrop.Width = 150;
            TextBlock tb2 = new TextBlock();
            tb2.Text = "Отменить перетаскивание";
            tb2.TextWrapping = TextWrapping.Wrap;
            cancelButDragAndDrop.Content = tb2;
            cancelButDragAndDrop.Width = 150;
            StackPanel sp21 = new StackPanel();
            sp21.Width = 10;
            spSaveDragDrop.Children.Add(saveButDragAndDrop);
            spSaveDragDrop.Children.Add(sp21);
            spSaveDragDrop.Children.Add(cancelButDragAndDrop);
            spSaveDragDrop.Visibility = System.Windows.Visibility.Collapsed;
            TopSP.Children.Add(spSaveDragDrop);

            TopSP.Children.Add(svHor);

            spOblast = new StackPanel();

            // панель в которой хранятся стенды (сверху вниз) и параметры справа
            panelMain.Orientation = Orientation.Horizontal;

            ScrollViewer sv = new ScrollViewer();
            sv.VerticalScrollBarVisibility = ScrollBarVisibility.Auto;
            sv.Height = 600;
            StackPanel panelStends = new StackPanel();
            panelStends.Orientation = Orientation.Vertical;
            sv.Content = panelStends;

            int i = 0;
            foreach (var item1 in XDocument.Parse(xmlDistricts).Root.Elements())
            {
                RayonyShort rs = new RayonyShort();
                rs.id = item1.Descendants("ID").FirstOrDefault().Value;
                rs.Rayon = item1.Descendants("Rayony").FirstOrDefault().Value;
                rs.X = int.Parse(item1.Descendants("X").FirstOrDefault().Value);
                rs.Y = int.Parse(item1.Descendants("Y").FirstOrDefault().Value);
                rs.isA6Hor = bool.Parse(item1.Descendants("IsA6Hor").FirstOrDefault().Value);
                //rs.isSocial = bool.Parse(item1.Descendants("IsSocial").FirstOrDefault().Value);
                panelStends.Children.Add(OneStend(item1, i));
                i++;
            }

            panelMain.Children.Add(sv);

            if (panelRight.Children.Count == 0)
            {
                // тип брони, период
                panelRight.Orientation = Orientation.Vertical;
                panelRight.Width = 350;

                // панель для отображения ФИО
                StackPanel sp1 = new StackPanel();
                sp1.Height = 25;
                TextBlock tb = new TextBlock();
                tb.Text = UserFullName;
                sp1.Children.Add(tb);
                panelRight.Children.Add(sp1);

                panelRight.Children.Add(spGorod);
                panelRight.Children.Add(AddFilter());
                panelRight.Children.Add(spOblast);
                panelRight.Children.Add(makeProcessArea());
                //panelRight.Children.Add(makeStat());

            }

            panelMain.Children.Add(panelRight);
        }

        void cancelButDragAndDrop_Click(object sender, RoutedEventArgs e)
        {
            // загрузить районы
            processMgrSoapClient.RetrieveDistrictAsync(rcbGorod.SelectedIndex + 1, rcbTip.SelectedValue.ToString());
        }

        void saveButDragAndDrop_Click(object sender, RoutedEventArgs e)
        {
            // сохранить все операции drag and drop
            bSaveProc_Click(true);
        }

        private void makeBronList(string tipBroni)
        {
            foreach (var item1 in XDocument.Parse(xmlBron).Root.Elements())
            {
                BronShort ps = new BronShort();
                ps.Name = item1.Descendants("Name").FirstOrDefault().Value;
                ps.Id = item1.Descendants("ID").FirstOrDefault().Value;
                ps.TipBroni = item1.Descendants("TipBroni").FirstOrDefault().Value;
                ps.UserId = item1.Descendants("UserID").FirstOrDefault().Value;
                ps.CreatedDate = item1.Descendants("CreatedDate").FirstOrDefault().Value;
                if (tipBroni == ps.TipBroni)
                    if (tipBroni == "0" || tipBroni == "2")
                        lbBron1.Items.Add(ps);
                    else if (tipBroni == "1")
                        lbBron2.Items.Add(ps);
                    else if (tipBroni == "3")
                        lbBron3.Items.Add(ps);
            }

            // processMgrSoapClient.RetrieveRazmFilterAsync(rcbGorod.SelectedValue.ToString(), (rcbPeriod.SelectedValue as PeriodShort).Id.ToString(), rcbTip.SelectedValue.ToString());
        }

        private UIElement OneStend(XElement item1, int z)
        {
            int X, Y;
            bool isA6Hor;
            string rayon;
            Button b;

            // выбранный стенд
            StackPanel panel2 = new StackPanel();
            panel2.Orientation = Orientation.Vertical;
            TextBlock tSpace = new TextBlock();
            tSpace.Height = 20;
            panel2.Children.Add(tSpace);
            TextBlock t = new TextBlock();
            rayon = item1.Descendants("Rayony").FirstOrDefault().Value;
            t.Text = rayon;
            int.TryParse(item1.Descendants("X").FirstOrDefault().Value, out X);
            int.TryParse(item1.Descendants("Y").FirstOrDefault().Value, out Y);
            bool.TryParse(item1.Descendants("IsA6Hor").FirstOrDefault().Value, out isA6Hor);
            t.Height = 30;
            panel2.Children.Add(t);

            // полоса
            StackPanel spPolosa = new StackPanel();
            spPolosa.Orientation = Orientation.Horizontal;
            spPolosa.Height = 20;
            Button but1 = new Button();
            but1.Width = ButtonWidthHor;
            but1.FontSize = 9;
            but1.Content = "Штрих-код И-Медиа";
            spPolosa.Children.Add(but1);
            buttonPolosa[z] = new Button();
            b = buttonPolosa[z];
            b.FontSize = 10;
            b.Width = ButtonWidthHor * 3;
            b.Content = PolosaString;
            b.Click += b_Click;
            b.Tag = new ButtonStruct();
            ButtonStruct bs = b.Tag as ButtonStruct;
            bs.X = -1;
            bs.Y = -1;
            bs.Z = z;
            bs.MaxX = X;
            bs.MaxY = Y;
            bs.Rayon = rayon;
            bs.isA6Hor = isA6Hor;
            bs.isPolosa = true;
            spPolosa.Children.Add(b);
            panel2.Children.Add(spPolosa);

            StackPanel panelStend0 = new StackPanel();
            panelStend0.Orientation = Orientation.Horizontal;

            // Canvas для стенда
            Canvas canvas = new Canvas();
            if (!isA6Hor)
            {
                ButtonWidthCur = ButtonWidth;
                ButtonHeightCur = ButtonHeight;
            }
            else
            {
                ButtonWidthCur = ButtonWidthHor;
                ButtonHeightCur = ButtonHeightHor;
            }
            canvas.Width = bs.MaxX * ButtonWidthCur;
            canvas.Height = bs.MaxY * ButtonHeightCur;


            for (int i = 0; i < Y; i++)
            {
                for (int j = 0; j < X; j++)
                {
                    buttonStend[z, i, j] = new Button();
                    b = buttonStend[z, i, j];
                    b.FontSize = 10;
                    b.Foreground = new SolidColorBrush(Colors.Black);
                    b.MouseEnter += b_MouseEnter;
                    b.MouseLeave += b_MouseLeave;
                    b.MouseLeftButtonDown += Handle_MouseDown;
                    b.MouseMove += Handle_MouseMove;
                    b.MouseLeftButtonUp += Handle_MouseUp;
                    b.MouseRightButtonDown += b_MouseRightButtonDown;
                    b.Click += b_Click;
                    b.Tag = new ButtonStruct();
                    bs = b.Tag as ButtonStruct;
                    bs.X = j;
                    bs.Y = i;
                    bs.Z = z;
                    bs.MaxX = X;
                    bs.MaxY = Y;
                    bs.Rayon = rayon;
                    bs.isA6Hor = isA6Hor;
                    bs.canvas = canvas;
                    // сформировать заголовок области A6
                    setSizePositionButton(ref b, 1, 1);
                    FillButton(b);
                    canvas.Children.Add(b);
                }
            }
            panelStend0.Children.Add(canvas);

            StackPanel sp11 = new StackPanel();
            sp11.Width = 10;
            panelStend0.Children.Add(sp11);

            StackPanel panelPocket = new StackPanel();
            panelPocket.Orientation = Orientation.Vertical;
            panelPocket.Width = 300;
            panelPocket.Height = ButtonHeightCur * bs.MaxY;
            StackPanel sp00 = new StackPanel();
            sp00.Orientation = Orientation.Horizontal;
            TextBlock tb00 = new TextBlock();
            tb00.Text = "Карман:";
            sp00.Children.Add(tb00);
            butConform[z] = new Button();
            butConform[z].Click += butConform_Click;
            butConform[z].Width = 180;
            butConform[z].Tag = z;
            butConform[z].Content = "Согласовать стенд";
            butConform[z].Height = 25;
            if (isROP)
                butConform[z].Visibility = System.Windows.Visibility.Visible;
            else
                butConform[z].Visibility = System.Windows.Visibility.Collapsed;
            sp00.Children.Add(butConform[z]);

            panelPocket.Children.Add(sp00);

            if (isROP)
            {
                panelStend0.Children.Add(panelPocket);
            }

            panel2.Children.Add(panelStend0);
            return panel2;
        }

        ButtonStruct bsSendTask = null;
        Button conformButton = null;
        void butConform_Click(object sender, RoutedEventArgs e)
        {
            conformButton = (sender as Button);
            if (isFullStend((int)conformButton.Tag))
            {
                MessageBox.Show("Стенд нельзя согласовать т.к. он не ВЕСЬ заполнен макетами (не везде есть картинки).");
                return;
            }
            MessageBoxResult result = MessageBox.Show("Стенд будет закрыт и поменять размещение на стенде после согласования будет невозможно. ",
                "Согласование стенда", MessageBoxButton.OKCancel);

            if (result == MessageBoxResult.OK)
            {
                // Отметить стенд как согласованный и запретить перетаскивание
                bsSendTask = (buttonStend[(int)conformButton.Tag, 0, 0].Tag as ButtonStruct);
                string Rayon = (buttonStend[(int)conformButton.Tag, 0, 0].Tag as ButtonStruct).Rayon;
                processMgrSoapClient.SetConformAsync(rcbGorod.SelectedValue.ToString(), Rayon, rcbTip.SelectedValue.ToString(), (rcbPeriod.SelectedValue as PeriodShort).Id);
            }

        }

        bool isFullStend(int firstIndex)
        {
            for (int i = 0; i < buttonStend.GetLength(1); i++)
            {
                for (int j = 0; j < buttonStend.GetLength(2); j++)
                {
                    if (buttonStend[(int)conformButton.Tag, i, j] != null)
                    {
                        ButtonStruct bs = (buttonStend[(int)conformButton.Tag, i, j].Tag as ButtonStruct);
                    }
                }
            }
            return false;
        }

        void b_MouseRightButtonDown(object sender, MouseButtonEventArgs e)
        {
            // Prevent the standard Silverlight popup           
            e.Handled = true;
            RadContextMenu.SetContextMenu(sender as Button, contextMenuButton);
        }

        public class ButtonStruct
        {
            public int ChoiceButton = 1; // 0 -  нет места, 1 - не отмечено, 2 - предв., 3 - обычная бронь, 4 - администратор, 5 - социалка
            public bool isCurrentProcess = false; // true - текущий процесс
            public int X; // позиция на стенде по оси Х
            public int Y; // позиция на стенде по оси Y
            public int Z; // номер района
            public int MaxX;
            public int MaxY;
            public string Rayon;
            public string format;
            public string idRazm = null; // id размещения
            public string idRazmFilter = null; // id размещения для всех форматов по фильтру
            public StringBuilder sbDel = new StringBuilder();
            public bool isFirstDeleted = true;
            public string BronName;
            public string userFIO;
            public string createdDate;
            public bool isA6Hor = false;
            public bool isPolosa = false; // это формат полосы
            public string parent; // id брони
            public bool isKarman = false; // true - находится в кармане
            public string idChild = null; // id размещения в дочерних кнопках
            public BitmapImage image = null;
            public string imageStr = "";
            public string imageName = null;
            public bool isConform = false;
            public Canvas canvas;
            //public bool isMove = false;
        };

        // нажатие ячейки на стенде
        void b_Click(object sender, RoutedEventArgs e)
        {
            Button b = sender as Button;
            if ((b.Tag as ButtonStruct).ChoiceButton > 1 && (b.Tag as ButtonStruct).isCurrentProcess == false)
                return;
            int z = (b.Tag as ButtonStruct).Z;
            if (butConform[z].IsEnabled == false)
            {
                MessageBox.Show("Стенд уже согласован и менять его нельзя.");
                return;
            }
            if (lbBron1.SelectedItem == null && lbBron2.SelectedItem == null && lbBron3.SelectedItem == null)
            {
                MessageBox.Show("Вначале выберите бронь или забронируйте новое место");
                return;
            }
            if ((b.Tag as ButtonStruct).ChoiceButton > 1)
            {
                (b.Tag as ButtonStruct).ChoiceButton = 1;
                (b.Tag as ButtonStruct).format = null;
                (b.Tag as ButtonStruct).idChild = null;
                if ((b.Tag as ButtonStruct).idRazm == "-1")
                    (b.Tag as ButtonStruct).idRazm = null;
                (b.Tag as ButtonStruct).isCurrentProcess = false;
                FillButton(b);
            }
            else
            {
                if (isAdmin)
                    (b.Tag as ButtonStruct).ChoiceButton = PREBRON_ADMIN;
                else
                    (b.Tag as ButtonStruct).ChoiceButton = PREBRON;
                (b.Tag as ButtonStruct).isCurrentProcess = true;
            }
            setFormat(b, Formats.Length);
        }

        // распознавание формата на стенде
        private void setFormat(Button b, int l)
        {
            int MaxX = (b.Tag as ButtonStruct).MaxX;
            int MaxY = (b.Tag as ButtonStruct).MaxY;
            int Z = (b.Tag as ButtonStruct).Z;

            // сбросить все форматы
            for (int i = 0; i < MaxX; i++)
                for (int j = 0; j < MaxY; j++)
                {
                    Button bArr = buttonStend[Z, j, i];
                    (bArr.Tag as ButtonStruct).format = null;
                    (bArr.Tag as ButtonStruct).idChild = null;
                }

            for (int pr = 0; pr < l; pr++)
            {
                for (int i = 0; i < MaxX; i++)
                    for (int j = 0; j < MaxY; j++)
                    {
                        Button bArr = buttonStend[Z, j, i];
                        // если состояние кнопки - нажата (только текущий формат) и ((нет формата и нет маркера) или (есть маркер левого верхнего угла))
                        if ((bArr.Tag as ButtonStruct).ChoiceButton > 1 && (bArr.Tag as ButtonStruct).isCurrentProcess)
                        {
                            if (((bArr.Tag as ButtonStruct).idRazm != null) ||
                                ((bArr.Tag as ButtonStruct).idRazm == null && (bArr.Tag as ButtonStruct).format == null))
                                checkAX(bArr, pr);
                        }

                    }
            }
            // полоса
            Button b1 = buttonPolosa[Z];
            SetPolosa(b1);

        }
        private void SetPolosa(Button b)
        {
            if ((b.Tag as ButtonStruct).isCurrentProcess)
                if ((b.Tag as ButtonStruct).idRazm == null)
                {
                    (b.Tag as ButtonStruct).idRazm = "-1";
                    (b.Tag as ButtonStruct).format = PolosaString;
                }
            FillButton(b);
        }

        private void checkAX(Button b, int pr)
        {
            int xx, yy;
            choiceFormat(pr, (b.Tag as ButtonStruct).isA6Hor, out xx, out yy);
            int X = (b.Tag as ButtonStruct).X;
            int Y = (b.Tag as ButtonStruct).Y;
            int Z = (b.Tag as ButtonStruct).Z;
            int MaxX = (b.Tag as ButtonStruct).MaxX;
            int MaxY = (b.Tag as ButtonStruct).MaxY;

            bool isThis = true;
            for (int i = X; i < X + xx; i++)
                for (int j = Y; j < Y + yy; j++)
                {
                    if (j >= MaxY || i >= MaxX)
                    {
                        isThis = false;
                        break;
                    }
                    if ((buttonStend[Z, j, i].Tag as ButtonStruct).ChoiceButton != (b.Tag as ButtonStruct).ChoiceButton
                        || (buttonStend[Z, j, i].Tag as ButtonStruct).isCurrentProcess != (b.Tag as ButtonStruct).isCurrentProcess)
                    {
                        isThis = false;
                        break;
                    }
                }

            if (isThis)
            {
                bool isFirst = true;
                Button b1 = buttonStend[0, 0, 0];
                for (int i = X; i < X + xx && i < MaxX; i++)
                    for (int j = Y; j < Y + yy && j < MaxY; j++)
                    {
                        // привязать к левому верхнему углу формат размещения
                        if (isFirst)
                        {
                            if ((buttonStend[Z, j, i].Tag as ButtonStruct).idRazm == null)
                                (buttonStend[Z, j, i].Tag as ButtonStruct).idRazm = "-1";
                            b1 = buttonStend[Z, j, i];
                            isFirst = false;
                        }
                        else
                        {
                            string sCur = (buttonStend[Z, j, i].Tag as ButtonStruct).idRazm;
                            if (sCur != null && int.Parse(sCur) > 0) // ячейка уже сохранялась в базе данных
                            {
                                if ((b1.Tag as ButtonStruct).idRazm == "-1" || (b1.Tag as ButtonStruct).idRazm == null)
                                    (b1.Tag as ButtonStruct).idRazm = (buttonStend[Z, j, i].Tag as ButtonStruct).idRazm;
                                else
                                {
                                    if ((b1.Tag as ButtonStruct).isFirstDeleted)
                                    {
                                        (b1.Tag as ButtonStruct).isFirstDeleted = false;
                                        (b1.Tag as ButtonStruct).sbDel.Append("<Deleted>");
                                        (b1.Tag as ButtonStruct).sbDel.Append("</Deleted>");
                                    }
                                    XDocument xdocNew = XDocument.Parse((b1.Tag as ButtonStruct).sbDel.ToString());
                                    // поглощение удалённых
                                    string s = (buttonStend[Z, j, i].Tag as ButtonStruct).sbDel.ToString();
                                    if (s.Length > 0)
                                    {
                                        XDocument xdocOld = XDocument.Parse(s);
                                        foreach (var x1 in xdocOld.Root.Elements())
                                        {
                                            xdocNew.Element("Deleted").Add(new XElement("ID", x1.Value));
                                        }
                                    }

                                    xdocNew.Element("Deleted").Add(new XElement("ID", sCur));
                                    (b1.Tag as ButtonStruct).sbDel.Clear();
                                    (b1.Tag as ButtonStruct).sbDel.Append(xdocNew.ToString());
                                    // формировать на удаление
                                }
                            }
                            (buttonStend[Z, j, i].Tag as ButtonStruct).idRazm = null;
                        }

                        (buttonStend[Z, j, i].Tag as ButtonStruct).format = Formats[pr];
                        FillButton(buttonStend[Z, j, i]);
                    }
            }

        }

        private void choiceFormat(int pr, bool isHor, out int xx, out int yy)
        {
            xx = 0; yy = 0;
            string sticker = "Усл. по разм. стикеров";
            string brendDoor = "Разм. рекл. на дверях лифта";
            switch (pr)
            {
                // Разм. рекл. на дверях лифта
                // Усл. по разм. стикеров
                case 0: // на панелях управления
                    if (rcbTip.SelectedValue.ToString() == brendDoor)
                    {
                        xx = 1;
                        yy = 1;
                    }
                    break;
                case 1: // стикеры
                    if (rcbTip.SelectedValue.ToString() == sticker)
                    {
                        xx = 1;
                        yy = 1;
                    }
                    break;
                case 2: // A6
                    if (rcbTip.SelectedValue.ToString() != brendDoor && rcbTip.SelectedValue.ToString() != sticker)
                    {
                        xx = 1;
                        yy = 1;
                    }
                    break;
                case 3: // A5
                    if (!isHor)
                    {
                        xx = 2;
                        yy = 1;
                    }
                    else
                    {
                        xx = 1;
                        yy = 2;
                    }
                    break;
                case 4: // A5+A6
                    if (!isHor)
                    {
                        xx = 3;
                        yy = 1;
                    }
                    else
                    {
                        xx = 1;
                        yy = 3;
                    }
                    break;
                case 5: // A4 Горизонтальный
                    if (!isHor)
                    {
                        xx = 4;
                        yy = 1;
                    }
                    else
                    {
                        xx = 2;
                        yy = 2;
                    }
                    break;
                case 6: // A4
                    if (!isHor)
                    {
                        xx = 2;
                        yy = 2;
                    }
                    else
                    {
                        xx = 1;
                        yy = 4;
                    }
                    break;
                case 7: // A3 Горизонтальный
                    if (!isHor)
                    {
                        xx = 8;
                        yy = 1;
                    }
                    else
                    {
                        xx = 4;
                        yy = 2;
                    }
                    break;
                case 8: // A3
                    if (!isHor)
                    {
                        xx = 4;
                        yy = 2;
                    }
                    else
                    {
                        xx = 2;
                        yy = 4;
                    }
                    break;
                case 9: // A3 вертикальный
                    if (!isHor)
                    {
                        xx = 2;
                        yy = 4;
                    }
                    else
                    {
                        xx = 1;
                        yy = 8;
                    }
                    break;
                case 10: // A2
                    if (!isHor)
                    {
                        xx = 4;
                        yy = 4;
                    }
                    else
                    {
                        xx = 2;
                        yy = 8;
                    }
                    break;
                case 11: // A2 Гор
                    if (!isHor)
                    {
                        xx = 8;
                        yy = 2;
                    }
                    else
                    {
                        xx = 4;
                        yy = 4;
                    }
                    break;
                case 12: // A1
                    if (!isHor)
                    {
                        xx = 8;
                        yy = 4;
                    }
                    else
                    {
                        xx = 4;
                        yy = 8;
                    }
                    break;
                default:
                    break;
            }
        }

        // отобразить кнопки на стенде
        private void FillButton(Button b)
        {
            int c = (b.Tag as ButtonStruct).ChoiceButton;
            switch (c)
            {
                case 1:
                    b.Foreground = new SolidColorBrush(Colors.Black);
                    if (ctDefault != null)
                        b.Template = ctDefault;
                    break;
                case 2:
                case 3:
                case 4:
                case 5:
                    if (ctDefault == null)
                        ctDefault = b.Template;
                    ControlTemplate ct;
                    if ((b.Tag as ButtonStruct).isCurrentProcess)
                    {
                        ct = XamlReader.Load(sbTemplateCur.ToString()) as ControlTemplate;
                        b.Foreground = new SolidColorBrush(Colors.White);
                    }
                    else if (c == 2)
                    {
                        ct = XamlReader.Load(sbTemplate.ToString()) as ControlTemplate;
                        b.Foreground = new SolidColorBrush(Colors.Black);
                    }
                    else if (c == 3)
                    {
                        ct = XamlReader.Load(sbTemplate1.ToString()) as ControlTemplate;
                        b.Foreground = new SolidColorBrush(Colors.Black);
                    }
                    else if (c == 4)
                    {
                        ct = XamlReader.Load(sbTemplate2.ToString()) as ControlTemplate;
                        b.Foreground = new SolidColorBrush(Colors.White);
                    }
                    else 
                    {
                        ct = XamlReader.Load(sbTemplate3.ToString()) as ControlTemplate;
                        b.Foreground = new SolidColorBrush(Colors.Black);
                    }
                    b.Template = ct;
                    break;
            }
            string format = (b.Tag as ButtonStruct).format;
            if (format == null)
            {
                if ((b.Tag as ButtonStruct).isPolosa)
                    b.Content = PolosaString;
                else
                {
                    int j = (b.Tag as ButtonStruct).X;
                    int i = (b.Tag as ButtonStruct).Y;
                    string s = "";
                    if (j == 0) s = "A"; else if (j == 1) s = "B"; else if (j == 2) s = "C"; else if (j == 3) s = "D"; else if (j == 4) s = "E"; else if (j == 5) s = "F"; else if (j == 6) s = "G"; else if (j == 7) s = "H";
                    b.Content = s + (i + 1).ToString();
                }
            }
            else
            {
                string s = (b.Tag as ButtonStruct).format + "\r\n" + (b.Tag as ButtonStruct).userFIO + "\r\n(" + (b.Tag as ButtonStruct).BronName + ")";
                b.Content = s;
                s = (b.Tag as ButtonStruct).BronName + "\r\n" + (b.Tag as ButtonStruct).userFIO + "\r\n" + (b.Tag as ButtonStruct).idRazmFilter + "\r\n" + format;
                if ((b.Tag as ButtonStruct).image != null)
                    s = s + "\r\nРазмер картинки:" + (b.Tag as ButtonStruct).image.PixelWidth + "x" + (b.Tag as ButtonStruct).image.PixelHeight;
                ToolTipService.SetToolTip(b, s);
            }

            if ((b.Tag as ButtonStruct).image != null)
            {
                Image im = new Image();
                im.SetValue(Image.SourceProperty, (b.Tag as ButtonStruct).image);
                b.Content = im;
            }


        }

        void b_MouseLeave(object sender, MouseEventArgs e)
        {
            Button b = sender as Button;
            b.ClickMode = ClickMode.Press;
        }

        void b_MouseEnter(object sender, MouseEventArgs e)
        {
            Button b = sender as Button;
            ButtonStruct bs = b.Tag as ButtonStruct;
            if ((bs.ChoiceButton == 3 || bs.ChoiceButton == 5 || bs.ChoiceButton == 4) && bs.isCurrentProcess == false)
                b.ClickMode = ClickMode.Hover;
            else
                b.ClickMode = ClickMode.Press;

        }
        /*
        RadComboBox rcbFormat;
        private UIElement makeFormat(string xmlContent)
        {
            StackPanel panel1 = new StackPanel();
            panel1.Orientation = Orientation.Horizontal;
            panel1.Width = 100;
            panel1.Height = 50;

            // формат для текущего стенда
            StackPanel sp03 = new StackPanel();
            sp03.Orientation = Orientation.Vertical;
            sp03.Width = 100;
            TextBlock tb3 = new TextBlock();
            tb3.Text = "Формат:";
            rcbFormat = new RadComboBox();
            rcbFormat.SelectionChanged += rcbFormat_SelectionChanged;
            foreach (var item1 in XDocument.Parse(xmlFormat).Root.Elements())
            {
                string s = item1.Descendants("Format").FirstOrDefault().Value;
                rcbFormat.Items.Add(s);
            }
            rcbFormat.SelectedIndex = 0;
            sp03.Children.Add(tb3);
            sp03.Children.Add(rcbFormat);
            panel1.Children.Add(sp03);

            return panel1;
        }
        */
        public class BronShort
        {
            public string Id;
            public string Name;
            public string TipBroni;
            public string UserId;
            public string CreatedDate;
            public override string ToString()
            {
                return Name + string.Format(" ({0:R})", CreatedDate);
            }
        }

        /*
        // процесс для текущего стенда
        RadComboBox rcbProcess;
        private UIElement makeProcess()
        {
            StackPanel panel1 = new StackPanel();
            panel1.Orientation = Orientation.Horizontal;
            panel1.Width = 100;
            panel1.Height = 50;

            // процесс для текущего стенда
            StackPanel sp03 = new StackPanel();
            sp03.Orientation = Orientation.Vertical;
            sp03.Width = 100;
            TextBlock tb3 = new TextBlock();
            tb3.Text = "Процесс:";
            rcbProcess = new RadComboBox();
            rcbProcess.SelectionChanged += rcbProcess_SelectionChanged;
            foreach (var item1 in XDocument.Parse(xmlBron).Root.Elements())
            {
                ProcessShort ps = new ProcessShort();
                ps.Name = item1.Descendants("Name").FirstOrDefault().Value;
                ps.Id = item1.Descendants("ID").FirstOrDefault().Value;
                ps.TipBroni = item1.Descendants("TipBroni").FirstOrDefault().Value;
                rcbProcess.Items.Add(ps);
            }
            rcbProcess.SelectedIndex = 0;
            sp03.Children.Add(tb3);
            sp03.Children.Add(rcbProcess);
            panel1.Children.Add(sp03);

            return panel1;
        }
         * */

        private UIElement makeStat()
        {
            StackPanel panel1 = new StackPanel();
            panel1.Orientation = Orientation.Vertical;
            panel1.Width = 100;
            panel1.Height = 200;
            return panel1;
        }

        public class RazmShort
        {
            public string Id;
            public string Rayon;
            public string Format;
            public string Period;
            public string PeriodName;
            public string Tip;
            public string MarkStend;
            public override string ToString()
            {
                return Id + " " + PeriodName + " " + Rayon + " " + Tip + " " + Format;
            }
        }

        RadListBox lbBron1 = new RadListBox();
        RadListBox lbBron2 = new RadListBox();
        RadListBox lbBron3 = new RadListBox();
        bool IsSaveButton = false;
        Button bButton = new Button();
        RadTabControl tabMain = new RadTabControl();
        TextBox tbInfo = new TextBox();
        private UIElement makeProcessArea()
        {
            StackPanel panel1 = new StackPanel();
            panel1.Orientation = Orientation.Vertical;
            ShowButton();
            bButton.Click += bButton_Click;
            panel1.Children.Add(bButton);


            RadTabItem tabItem1 = new RadTabItem();
            tabItem1.Header = "Бронь";
            tabItem1.Content = lbBron1;

            RadTabItem tabItem2 = new RadTabItem();
            tabItem2.Content = lbBron2;
            tabItem2.Header = "Продано";
            
            RadTabItem tabItem3 = new RadTabItem();
            tabItem3.Content = lbBron3;
            tabItem3.Header = "Социалка";

            lbBron1.SelectionChanged += lbBron1_SelectionChanged;
            lbBron2.SelectionChanged += lbBron2_SelectionChanged;
            lbBron3.SelectionChanged += lbBron3_SelectionChanged;
            tabMain.Height = 180;
            tabMain.Items.Add(tabItem1);
            tabMain.Items.Add(tabItem2);
            tabMain.Items.Add(tabItem3);

            panel1.Children.Add(tabMain);
            ScrollViewer svHor = new ScrollViewer();
            svHor.Content = tbInfo;
            svHor.HorizontalScrollBarVisibility = ScrollBarVisibility.Auto;
            svHor.Height = 200;
            tbInfo.FontSize = 12;
            tbInfo.AcceptsReturn = true;
            tbInfo.IsReadOnly = true;
            tbInfo.Text = "Информация о брони.";
            panel1.Children.Add(svHor);

            return panel1;
        }

        void lbBron1_SelectionChanged(object sender, Telerik.Windows.Controls.SelectionChangedEventArgs e)
        {
            currentBron = (sender as RadListBox).SelectedValue as BronShort;
            if (currentBron == null)
                return;
            lbBron2.SelectedItem = null;
            lbBron3.SelectedItem = null;
            currentBron = (sender as RadListBox).SelectedValue as BronShort;
            if (isFirstLoaded)
                return;
            cwPreBron.TextBlock1.Text = currentBron.Name;
            // retrieve data for stends of rayons
            processMgrSoapClient.RetrieveRazmAsync(currentBron.Id);

            cwPreBron.Show();

        }

        void lbBron2_SelectionChanged(object sender, Telerik.Windows.Controls.SelectionChangedEventArgs e)
        {
            currentBron = (sender as RadListBox).SelectedValue as BronShort;
            if (currentBron == null)
                return;
            lbBron1.SelectedItem = null;
            lbBron3.SelectedItem = null;
            currentBron = (sender as RadListBox).SelectedValue as BronShort;
            if (isFirstLoaded)
                return;
            cwProdano.TextBlock1.Text = currentBron.Name;
            // retrieve data for stends of rayons
            processMgrSoapClient.RetrieveRazmAsync(currentBron.Id);
            cwProdano.Show();

        }

        void lbBron3_SelectionChanged(object sender, Telerik.Windows.Controls.SelectionChangedEventArgs e)
        {
            currentBron = (sender as RadListBox).SelectedValue as BronShort;
            if (currentBron == null)
                return;
            lbBron1.SelectedItem = null;
            lbBron2.SelectedItem = null;
            currentBron = (sender as RadListBox).SelectedValue as BronShort;
            if (isFirstLoaded)
                return;
            cwProdano.TextBlock1.Text = currentBron.Name;
            // retrieve data for stends of rayons
            processMgrSoapClient.RetrieveRazmAsync(currentBron.Id);
            cwProdano.Show();

        }

        private string makeXmlRazm(int Z, int X, int Y, string format, bool isAll)
        {
            StringBuilder sb = new StringBuilder();
            int pr = getIndexFormat(format);
            if (pr == -1)
            {
                sb.Append("<Stend>");
                sb.Append("</Stend>");
                return sb.ToString(); ;
            }
            int xx = 0, yy = 0;
            if (buttonStend[0, 0, 0] != null)
                choiceFormat(pr, (buttonStend[0, 0, 0].Tag as ButtonStruct).isA6Hor, out xx, out yy);
            // формирование xml для текущего размещения
            sb.Append("<Stend>");
            for (int i = X; i < X + xx; i++)
            {
                for (int j = Y; j < Y + yy; j++)
                {
                    Button b = buttonStend[Z, j, i];
                    // брать только для выбранного размещения
                    if (((b.Tag as ButtonStruct).isCurrentProcess && !isAll) || isAll)
                    {
                        sb.Append("<Cell>");
                        sb.Append("<X>");
                        sb.Append(i.ToString());
                        sb.Append("</X>");
                        sb.Append("<Y>");
                        sb.Append(j.ToString());
                        sb.Append("</Y>");
                        sb.Append("</Cell>");
                    }
                }
            }
            sb.Append("</Stend>");
            return sb.ToString();
        }

        // сохранить текущее размещение в базу данных
        /// <summary>
        /// isAll == true - все макеты со стенда сохранить после перетаскивания
        /// isAll == false - сохранить текущие макеты
        /// </summary>
        /// <param name="isAll"></param>
        void bSaveProc_Click(bool isAll)
        {
            StringBuilder sb1 = new StringBuilder();
            sb1.Append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
            sb1.Append("<Razm>");
            int z = 0;
            bool isEmtpyKarman = true;
            foreach (var item1 in XDocument.Parse(xmlDistricts).Root.Elements()) // для каждого района
            {
                int X, Y;
                int.TryParse(item1.Descendants("X").FirstOrDefault().Value, out X);
                int.TryParse(item1.Descendants("Y").FirstOrDefault().Value, out Y);
                // если есть отмеченные форматы на стенде
                for (int i = 0; i < Y; i++)
                    for (int j = 0; j < X; j++)
                    {
                        if ((buttonStend[z, i, j].Tag as ButtonStruct).isKarman)
                            isEmtpyKarman = false;
                        bool isSavePriznakCurrent = ((isAll == false) && ((buttonStend[z, i, j].Tag as ButtonStruct).idRazm != null));
                        bool isSavePriznakAll = ((isAll == true) && ((buttonStend[z, i, j].Tag as ButtonStruct).idRazmFilter != null));
                        if (isSavePriznakCurrent || isSavePriznakAll)
                        {
                            sb1.Append("<RazmOne>");
                            sb1.Append("<Period>");
                            sb1.Append((rcbPeriod.SelectedValue as PeriodShort).Id.ToString());
                            sb1.Append("</Period>");
                            sb1.Append("<District>");
                            sb1.Append(item1.Descendants("Rayony").FirstOrDefault().Value);
                            sb1.Append("</District>");
                            sb1.Append("<Tip>");
                            sb1.Append(rcbTip.SelectedValue.ToString());
                            sb1.Append("</Tip>");
                            sb1.Append("<Format>");
                            sb1.Append((buttonStend[z, i, j].Tag as ButtonStruct).format);
                            sb1.Append("</Format>");
                            sb1.Append("<Parent>");
                            string parent = (buttonStend[z, i, j].Tag as ButtonStruct).parent;
                            if (parent == null)
                                parent = currentBron.Id;
                            sb1.Append(parent);
                            sb1.Append("</Parent>");
                            sb1.Append(makeXmlRazm(z, j, i, (buttonStend[z, i, j].Tag as ButtonStruct).format, isAll));
                            sb1.Append((buttonStend[z, i, j].Tag as ButtonStruct).sbDel.ToString());
                            sb1.Append("<IDRazm>");
                            if (isAll)
                                sb1.Append((buttonStend[z, i, j].Tag as ButtonStruct).idRazmFilter);
                            else
                                sb1.Append((buttonStend[z, i, j].Tag as ButtonStruct).idRazm);
                            sb1.Append("</IDRazm>");
                            sb1.Append("</RazmOne>");
                        }
                        FillButton(buttonStend[z, i, j]);
                    }
                // полоса
                if ((buttonPolosa[z].Tag as ButtonStruct).idRazm != null)
                {
                    sb1.Append("<RazmOne>");
                    sb1.Append("<Period>");
                    sb1.Append((rcbPeriod.SelectedValue as PeriodShort).Id.ToString());
                    sb1.Append("</Period>");
                    sb1.Append("<District>");
                    sb1.Append(item1.Descendants("Rayony").FirstOrDefault().Value);
                    sb1.Append("</District>");
                    sb1.Append("<Tip>");
                    sb1.Append(rcbTip.SelectedValue.ToString());
                    sb1.Append("</Tip>");
                    sb1.Append("<Format>");
                    sb1.Append((buttonPolosa[z].Tag as ButtonStruct).format);
                    sb1.Append("</Format>");
                    sb1.Append("<Parent>");
                    string parent = (buttonPolosa[z].Tag as ButtonStruct).parent;
                    if (parent == null)
                        parent = currentBron.Id;
                    sb1.Append(parent);
                    sb1.Append("</Parent>");
                    if ((buttonPolosa[z].Tag as ButtonStruct).format != null)
                        sb1.Append("<Stend> <Cell></Cell> </Stend>");
                    else
                        sb1.Append("<Stend></Stend>");
                    sb1.Append((buttonPolosa[z].Tag as ButtonStruct).sbDel.ToString());
                    sb1.Append("<IDRazm>");
                    if (isAll)
                        sb1.Append((buttonPolosa[z].Tag as ButtonStruct).idRazmFilter);
                    else
                        sb1.Append((buttonPolosa[z].Tag as ButtonStruct).idRazm);
                    sb1.Append("</IDRazm>");
                    sb1.Append("</RazmOne>");
                }
                z++;
            }
            sb1.Append("</Razm>");
            if (isEmtpyKarman == false)
            {
                MessageBox.Show("Перенесите из кармана все макеты обратно на стенд или отмените перетаскивание макетов.");
                return;
            }
            // сохранить в базу данных размещение
            processMgrSoapClient.UpdateRazmAsync(sb1.ToString());
            spSaveDragDrop.Visibility = System.Windows.Visibility.Collapsed;
        }


        bool isNewBron = false;
        // Создать новую бронь или сохранить выбранную
        void bButton_Click(object sender, RoutedEventArgs e)
        {
            if (IsSaveButton)
            {
                if (currentBron != null)
                    bSaveProc_Click(false);
                IsSaveButton = false;
                ShowButton();
            }
            else
            {
                cwNewProc.Show();
            }
        }

        void cwNewProc_Closed(object sender, EventArgs e)
        {
            ChildWindow1 cw = (sender as ChildWindow1);
            string name = "";

            if (cw.DialogResult == false)
                return;
            name = cw.nameBox.Text;
            StringBuilder sb = new StringBuilder();
            sb.Append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
            sb.Append("<Insert>");
            sb.Append("<Name>");
            sb.Append(name);
            sb.Append("</Name>");
            sb.Append("<Gorod>");
            sb.Append(rcbGorod.SelectedValue.ToString());
            sb.Append("</Gorod>");
            sb.Append("<Period>");
            sb.Append(rcbPeriod.SelectedValue.ToString());
            sb.Append("</Period>");
            sb.Append("<District>");
            //sb.Append(rcbDistrict.SelectedValue.ToString());
            sb.Append("</District>");
            sb.Append("<Tip>");
            sb.Append(rcbTip.SelectedValue.ToString());
            sb.Append("</Tip>");
            sb.Append("<UserID>");
            sb.Append(CurrentUser.CurrentUserId.ToString());
            sb.Append("</UserID>");
            sb.Append("</Insert>");
            isFirstLoaded = true;
            isNewBron = true;
            processMgrSoapClient.CreateProcessAsync(sb.ToString(), (isAdmin) ? "2" : "0");

        }

        void cwPreBron_Closed(object sender, EventArgs e)
        {
            ChildWindowPreBron cw = sender as ChildWindowPreBron;

            if (cw.DialogResult == false)
                return;
            if (cw.Choice == 0)
            {
                isFirstLoaded = true;
                processMgrSoapClient.UpdateProcessAsync(currentBron.Id, "1"); // перевести текущую бронь в продано
                startProcess(currentBron.Id.ToString(), currentBron.Name);
            }
            if (cw.Choice == 3)
            {
                isFirstLoaded = true;
                processMgrSoapClient.UpdateProcessAsync(currentBron.Id, "3"); // перевести текущую бронь в социалку
                startProcess(currentBron.Id.ToString(), currentBron.Name);
            }
            if (cw.Choice == 1)
            {
                isFirstLoaded = true;
                processMgrSoapClient.DeleteBronRazmAsync(currentBron.Id.ToString());
            }
            if (cw.Choice == 2)
            {
                IsSaveButton = true;
                ShowButton();
            }
        }

        void cwProdano_Closed(object sender, EventArgs e)
        {
            ChildWindow2 cw = sender as ChildWindow2;

            if (cw.DialogResult == false)
                return;
            if (cw.Choice == 0) // отменить сделку (удаление процесса и удаление в проданной брони)
            {
                isFirstLoaded = true;
                processMgrSoapClient.DeleteProcessAsync(currentBron.Id.ToString());
            }
            if (cw.Choice == 1)
            {
                IsSaveButton = true;
                ShowButton();
            }
        }

        void makeFilters()
        {

            /*
            tabMain.Items.Clear(); // очистить
            // создать боковые закладки 
            foreach (var item in XDocument.Parse(xmlPeriods).Root.Elements())
            {
                RadTabItem tabItem1 = new RadTabItem();
                tabItem1.Header = item.Descendants("NazvaniePerioda").FirstOrDefault().Value;
                tabItem1.Tag = item;
                tabMain.Items.Add(tabItem1);
                DateTime dt1 = DateTime.Parse(item.Descendants("DataNachalaPerioda").FirstOrDefault().Value);
                DateTime dt2 = DateTime.Parse(item.Descendants("DataOkonchaniyaPerioda").FirstOrDefault().Value);
                if (DateTime.Now > dt1 && DateTime.Now < dt2)
                {
                    tabItem1.IsSelected = true;
                }
            }
             * */
            //Districts = XDocument.Parse(xmlContent).Descendants("Rayony").Select(element => element.Value).ToArray();
        }

        public class RayonyShort
        {
            public string id;
            public string Rayon;
            public int X;
            public int Y;
            public bool isA6Hor;
            public bool isSocial;
            public override string ToString()
            {
                return Rayon;
            }
        }

        public class PeriodShort
        {
            public string Id;
            public string Name;
            public override string ToString()
            {
                return Name;
            }
        }

        RadComboBox rcbPeriod;
        RadComboBox rcbTip;
        StackPanel panelFilter = new StackPanel();
        private UIElement AddFilter()
        {
            panelFilter.Orientation = Orientation.Vertical;
            panelFilter.Width = 350;
            StackPanel panel = new StackPanel();
            panel.Orientation = Orientation.Vertical;
            panel.Width = 350;
            panel.Height = 150;
            panelFilter.Children.Add(panel);
            // периоды размещения
            StackPanel sp02 = new StackPanel();
            sp02.Orientation = Orientation.Vertical;
            TextBlock tb2 = new TextBlock();
            tb2.Text = "Период размещения:";
            rcbPeriod = new RadComboBox();
            foreach (var item1 in XDocument.Parse(xmlPeriods).Root.Elements())
            {
                PeriodShort ps = new PeriodShort();
                ps.Id = item1.Descendants("ID").FirstOrDefault().Value;
                ps.Name = item1.Descendants("NazvaniePerioda").FirstOrDefault().Value;
                rcbPeriod.Items.Add(ps);
                DateTime dt1 = DateTime.Parse(item1.Descendants("DataNachalaPerioda").FirstOrDefault().Value);
                DateTime dt2 = DateTime.Parse(item1.Descendants("DataOkonchaniyaPerioda").FirstOrDefault().Value);
                if (DateTime.Now.AddDays(15) >= dt1 && DateTime.Now.AddDays(15) < dt2.AddDays(1))
                {
                    rcbPeriod.SelectedValue = ps;
                }
            }
            if (rcbPeriod.SelectedValue == null)
                rcbPeriod.SelectedItem = rcbPeriod.Items.LastOrDefault();
            sp02.Children.Add(tb2);
            sp02.Children.Add(rcbPeriod);
            panel.Children.Add(sp02);
            rcbPeriod.SelectionChanged += rcbPeriod_SelectionChanged;
            // для промежутка
            StackPanel sp1 = new StackPanel();
            sp1.Height = 10;
            panel.Children.Add(sp1);
            // тип размещения
            StackPanel sp01 = new StackPanel();
            sp01.Orientation = Orientation.Vertical;
            TextBlock tb1 = new TextBlock();
            tb1.Text = "Тип размещения:";
            rcbTip = new RadComboBox();
            foreach (var item1 in XDocument.Parse(xmlTip).Root.Elements())
            {
                string s = item1.Descendants("Tip").FirstOrDefault().Value;
                rcbTip.Items.Add(s);
            }
            rcbTip.SelectedIndex = 0;
            sp01.Children.Add(tb1);
            sp01.Children.Add(rcbTip);
            panel.Children.Add(sp01);
            rcbTip.SelectionChanged += rcbTip_SelectionChanged;

            return panelFilter;
        }

        void rcbTip_SelectionChanged(object sender, Telerik.Windows.Controls.SelectionChangedEventArgs e)
        {
            queuePicture.Clear();
            if (rcbTip.SelectedValue == null || rcbGorod.SelectedValue == null || rcbPeriod.SelectedValue == null)
            {
                return;
            }
            ChangeFilter();
            // загрузить районы
            processMgrSoapClient.RetrieveDistrictAsync(rcbGorod.SelectedIndex + 1, rcbTip.SelectedValue.ToString());
        }

        void rcbPeriod_SelectionChanged(object sender, Telerik.Windows.Controls.SelectionChangedEventArgs e)
        {
            queuePicture.Clear();
            ChangeFilter();
            cwWaiting.Show();
            processMgrSoapClient.RetrieveRazmFilterAsync(rcbGorod.SelectedValue.ToString(), (rcbPeriod.SelectedValue as PeriodShort).Id.ToString(), rcbTip.SelectedValue.ToString());
        }

        // Global variables used to keep track of the 
        // mouse position and whether the object is captured
        // by the mouse.
        bool isMouseCaptured;
        double mouseVerticalPosition;
        double mouseHorizontalPosition;
        double mouseVerticalPositionHome;
        double mouseHorizontalPositionHome;

        public void Handle_MouseDown(object sender, MouseEventArgs args)
        {
            if (currentBron != null)
                return;
            if (isROP == false)
                return;
            Button item = sender as Button;
            if ((item.Tag as ButtonStruct).isConform)
                return;
            mouseVerticalPosition = args.GetPosition(null).Y;
            mouseHorizontalPosition = args.GetPosition(null).X;
            mouseVerticalPositionHome = (double)item.GetValue(Canvas.TopProperty);
            mouseHorizontalPositionHome = (double)item.GetValue(Canvas.LeftProperty);
            isMouseCaptured = true;
            item.CaptureMouse();
            item.SetValue(Canvas.ZIndexProperty, 100);
        }

        public void Handle_MouseMove(object sender, MouseEventArgs args)
        {
            if (currentBron != null)
                return;
            Button item = sender as Button;
            ButtonStruct bs = item.Tag as ButtonStruct;
            if (isMouseCaptured)
            {
                // Calculate the current position of the object.
                double deltaV = args.GetPosition(null).Y - mouseVerticalPosition;
                double deltaH = args.GetPosition(null).X - mouseHorizontalPosition;
                double newTop = deltaV + (double)item.GetValue(Canvas.TopProperty);
                double newLeft = deltaH + (double)item.GetValue(Canvas.LeftProperty);

                if (newLeft >= 0)
                {
                    item.SetValue(Canvas.LeftProperty, newLeft);
                    mouseHorizontalPosition = args.GetPosition(null).X;
                }

                if (bs.format == null)
                    return;
                if (newTop < 0)
                    return;
                int xx, yy;
                int pr = getIndexFormat(bs.format);
                choiceFormat(pr, bs.isA6Hor, out xx, out yy);
                if (newTop + yy * ButtonHeightCur > (item.Parent as Canvas).Height)
                    return;
                item.SetValue(Canvas.TopProperty, newTop);

                // Update position global variables.
                mouseVerticalPosition = args.GetPosition(null).Y;

            }
        }

        public void Handle_MouseUp(object sender, MouseEventArgs args)
        {
            if (currentBron != null)
                return;
            spSaveDragDrop.Visibility = System.Windows.Visibility.Visible;

            Button item = sender as Button;
            ButtonStruct bs = item.Tag as ButtonStruct;

            isMouseCaptured = false;
            item.ReleaseMouseCapture();
            mouseVerticalPosition = -1;
            mouseHorizontalPosition = -1;

            double newTop = (double)item.GetValue(Canvas.TopProperty);
            double newLeft = (double)item.GetValue(Canvas.LeftProperty);

            // Set position of button in cell
            if (newTop - (int)(newTop / ButtonHeightCur) * ButtonHeightCur <= ButtonHeightCur / 2)
                newTop = (int)(newTop / ButtonHeightCur) * ButtonHeightCur;
            else
                newTop = ((int)(newTop / ButtonHeightCur) + 1) * ButtonHeightCur;
            if (newLeft - (int)(newLeft / ButtonWidthCur) * ButtonWidthCur <= ButtonWidthCur / 2)
                newLeft = (int)(newLeft / ButtonWidthCur) * ButtonWidthCur;
            else
                newLeft = ((int)(newLeft / ButtonWidthCur) + 1) * ButtonWidthCur;

            // проверка выходит ли за границы стенда
            int xx, yy;
            int newX = (int)(newLeft / ButtonWidthCur);
            int newY = (int)(newTop / ButtonHeightCur);
            int oldX = bs.X;
            int oldY = bs.Y;
            int pr = getIndexFormat(bs.format);
            choiceFormat(pr, bs.isA6Hor, out xx, out yy);
            if (newX + xx > bs.MaxX && newX < bs.MaxX)
                newLeft = (bs.MaxX - xx) * ButtonWidthCur;
            if (newY + yy > bs.MaxY)
                newTop = (bs.MaxY - yy) * ButtonHeightCur;


            int z = bs.Z;
            // прервать, если площадь перемещаемой ячейки перекрывает не пустые ячейки чужого макета
            for (int i = newY; i < newY + yy; i++)
                for (int j = newX; j < newX + xx; j++)
                {
                    if (buttonStend[z, i, j] != null &&
                        (buttonStend[z, i, j].Tag as ButtonStruct).format != null &&
                        (buttonStend[z, i, j].Tag as ButtonStruct).isKarman == false &&
                        (buttonStend[z, i, j].Tag as ButtonStruct).idChild != bs.idChild)
                    {
                        item.SetValue(Canvas.TopProperty, mouseVerticalPositionHome);
                        item.SetValue(Canvas.LeftProperty, mouseHorizontalPositionHome);
                        return;
                    }
                }

            item.SetValue(Canvas.TopProperty, newTop);
            item.SetValue(Canvas.LeftProperty, newLeft);

            // прервать, если элемент приходит из кармана или перетаскивания не произошло
            if (newX == oldX && newY == oldY)
            {
                // сделать невидимыми дочерние ячейки на новом месте
                pr = getIndexFormat((buttonStend[z, newY, newX].Tag as ButtonStruct).format);
                choiceFormat(pr, (buttonStend[z, newY, newX].Tag as ButtonStruct).isA6Hor, out xx, out yy);
                SetVisibleChildCells(buttonStend[z, newY, newX], xx, yy, System.Windows.Visibility.Collapsed);
                (buttonStend[z, newY, newX].Tag as ButtonStruct).isKarman = false;
                return;
            }
            // сделать видимыми дочерние ячейки на старом месте
            SetVisibleChildCells(buttonStend[z, bs.Y, bs.X], xx, yy, System.Windows.Visibility.Visible);

            // прервать если выходит за рамки стенда, т.е. в кармане
            if (newX >= bs.MaxX || newY >= bs.MaxY)
            {
                bs.isKarman = true;
                return;
            }

            Button bChange = buttonStend[z, newY, newX];
            buttonStend[z, newY, newX] = buttonStend[z, bs.Y, bs.X];
            buttonStend[z, oldY, oldX] = bChange;

            (buttonStend[z, oldY, oldX].Tag as ButtonStruct).X = oldX;
            (buttonStend[z, oldY, oldX].Tag as ButtonStruct).Y = oldY;

            (buttonStend[z, newY, newX].Tag as ButtonStruct).X = newX;
            (buttonStend[z, newY, newX].Tag as ButtonStruct).Y = newY;

            // сделать невидимыми дочерние ячейки на новом месте
            pr = getIndexFormat((buttonStend[z, newY, newX].Tag as ButtonStruct).format);
            choiceFormat(pr, (buttonStend[z, newY, newX].Tag as ButtonStruct).isA6Hor, out xx, out yy);
            SetVisibleChildCells(buttonStend[z, newY, newX], xx, yy, System.Windows.Visibility.Collapsed);
            // размеры и позиции кнопки на кнопке поменять для заменяемой ячейки
            // не показывать новые позиции, т.к. ячейка в кармане
            if ((buttonStend[z, oldY, oldX].Tag as ButtonStruct).isKarman == false)
            {
                setSizePositionButton(ref buttonStend[z, oldY, oldX], 1, 1);
                FillButton(buttonStend[z, oldY, oldX]);
            }

            (buttonStend[z, newY, newX].Tag as ButtonStruct).isKarman = false;
        }
    }
}
