﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Net;
using System.Text;
using System.Web;
using System.Web.Services;
using System.Xml.Linq;

namespace IMS.Web
{
    /// <summary>
    /// Summary description for ProcessParamManager
    /// </summary>
    [WebService(Namespace = "http://tempuri.org/")]
    [WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
    [System.ComponentModel.ToolboxItem(false)]
    // To allow this Web Service to be called from script, using ASP.NET AJAX, uncomment the following line. 
    [System.Web.Script.Services.ScriptService]
    public class ProcessParamManager : System.Web.Services.WebService
    {

        [WebMethod]
        public string CreateProcess(string xmlContent, string tipBroni)
        {
            string s1, s2, s3, s4;
            s1 = Guid.NewGuid().ToString();
            XElement x = XDocument.Parse(xmlContent).Root;
            s2 = x.Descendants("Name").FirstOrDefault().Value;
            s3 = x.Descendants("Gorod").FirstOrDefault().Value;
            s4 = x.Descendants("UserID").FirstOrDefault().Value;

            try
            {
                SqlConnection _sqlConnection = new SqlConnection();
                _sqlConnection.ConnectionString = ConfigurationManager.ConnectionStrings["sqlConnectionString"].ToString();
                _sqlConnection.Open(); SqlDataAdapter da = new SqlDataAdapter();
                string s = string.Format("INSERT INTO Reservation (Uid, Name, Gorod, TipBroni, [User], CreatedDate) VALUES(N'{0}',N'{1}',N'{2}',N'{3}',{4}, getdate())", s1, s2, s3, tipBroni, s4);
                da.InsertCommand = new SqlCommand(s, _sqlConnection);
                da.InsertCommand.ExecuteNonQuery();

                da.SelectCommand = new SqlCommand("SELECT SCOPE_IDENTITY() id", _sqlConnection);
                DataSet ds = new DataSet();
                da.Fill(ds);
                StringBuilder sb = new StringBuilder();
                foreach (DataRow dr in ds.Tables[0].Rows)
                {
                    sb.Append(dr[0].ToString());
                }

                _sqlConnection.Close();
                return sb.ToString();
            }
            catch (Exception ex)
            {
                return string.Empty;
            }
        }

        [WebMethod]
        public string GetHost()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
            sb.Append("<AppSettings>");
            sb.Append("<HostElma>");
            sb.Append(System.Configuration.ConfigurationManager.AppSettings["HostElma"]);
            sb.Append("</HostElma>");
            sb.Append("<ApplicationToken>");
            sb.Append(System.Configuration.ConfigurationManager.AppSettings["ApplicationToken"]);
            sb.Append("</ApplicationToken>");
            sb.Append("</AppSettings>");
            return sb.ToString();
        }

        [WebMethod]
        public string UpdateProcess(string id, string tipBroni)
        {
            try
            {
                SqlConnection _sqlConnection = new SqlConnection();
                _sqlConnection.ConnectionString = ConfigurationManager.ConnectionStrings["sqlConnectionString"].ToString();
                _sqlConnection.Open(); SqlDataAdapter da = new SqlDataAdapter();
                string s = string.Format("UPDATE Reservation  SET TipBroni = N'{0}' WHERE id = {1}", tipBroni, id);
                da.UpdateCommand = new SqlCommand(s, _sqlConnection);
                da.UpdateCommand.ExecuteNonQuery();

                _sqlConnection.Close();
                return "";
            }
            catch (Exception ex)
            {
                return string.Empty;
            }
        }

        [WebMethod]
        public string SetConform(string Gorod, string Rayon, string Tip, string Period)
        {
            try
            {
                SqlConnection _sqlConnection = new SqlConnection();
                _sqlConnection.ConnectionString = ConfigurationManager.ConnectionStrings["sqlConnectionString"].ToString();
                _sqlConnection.Open(); SqlDataAdapter da = new SqlDataAdapter();
                string s = string.Format("UPDATE Reservation_ParametryRazmesc SET IsConform = 1 WHERE parent in (select id from reservation r where Gorod = N'{0}') and Rayon = N'{1}' and Tip = N'{2}' and Period={3}", Gorod, Rayon, Tip, Period);
                da.UpdateCommand = new SqlCommand(s, _sqlConnection);
                da.UpdateCommand.ExecuteNonQuery();

                _sqlConnection.Close();
                return "";
            }
            catch (Exception ex)
            {
                return string.Empty;
            }
        }

        [WebMethod]
        public string DeleteBronRazm(string id)
        {
            try
            {
                SqlConnection _sqlConnection = new SqlConnection();
                _sqlConnection.ConnectionString = ConfigurationManager.ConnectionStrings["sqlConnectionString"].ToString();
                _sqlConnection.Open(); SqlDataAdapter da = new SqlDataAdapter();
                string s = string.Format("DELETE FROM Reservation_ParametryRazmesc WHERE Parent = {0}", id);
                da.DeleteCommand = new SqlCommand(s, _sqlConnection);
                da.DeleteCommand.ExecuteNonQuery();

                s = string.Format("DELETE FROM Reservation WHERE Id = {0}", id);
                da.DeleteCommand = new SqlCommand(s, _sqlConnection);
                da.DeleteCommand.ExecuteNonQuery();

                _sqlConnection.Close();
                return "";
            }
            catch (Exception ex)
            {
                return string.Empty;
            }
        }


        [WebMethod]
        public string DeleteProcess(string idBron)
        {
            try
            {
                SqlConnection _sqlConnection = new SqlConnection();
                _sqlConnection.ConnectionString = ConfigurationManager.ConnectionStrings["sqlConnectionString"].ToString();
                _sqlConnection.Open(); SqlDataAdapter da = new SqlDataAdapter();
                string s = string.Format("UPDATE P_OsuschestvlenieSdelki1 SET IsDeleted=1 WHERE IdBron = {0}", idBron);
                da.UpdateCommand = new SqlCommand(s, _sqlConnection);
                da.UpdateCommand.ExecuteNonQuery();

                _sqlConnection.Close();
                return "";
            }
            catch (Exception ex)
            {
                return string.Empty;
            }
        }

        public static byte[] ImageToByte(Image img)
        {
            ImageConverter converter = new ImageConverter();
            return (byte[])converter.ConvertTo(img, typeof(byte[]));
        }


        [WebMethod]
        public string GetPicture(ref string imageName, int length, out byte[] image)
        {
            string filename = imageName;
            Guid guid; 
            if (Guid.TryParse(imageName, out guid))
            {
                // взять документ для Guid
                SqlConnection _sqlConnection = new SqlConnection();
                _sqlConnection.ConnectionString = ConfigurationManager.ConnectionStrings["sqlConnectionString"].ToString();
                _sqlConnection.Open(); SqlDataAdapter da = new SqlDataAdapter();
                da.SelectCommand = new SqlCommand(string.Format("select id from fs_files where uid = N'{0}'", imageName), _sqlConnection);

                DataSet ds = new DataSet();
                da.Fill(ds);
                foreach (DataRow dr in ds.Tables[0].Rows)
                {
                    filename = dr[0].ToString();
                }
            }
            string path = @"C:\ELMA3-Standart\UserConfig\Files\" + filename + ".jpg";
            Image image1 = null;
            image = null;

            if (File.Exists(path))
            {
                if (length == new FileInfo(path).Length)
                    return string.Empty;
                    try
                    {
                        image1 = Image.FromFile(path, true);
                    }
                    catch (Exception ex) { }
            }
            else
            {
                path = @"C:\ELMA3-Standart\UserConfig\Files\" + filename + ".png";
                if (File.Exists(path))
                {
                    if (length == new FileInfo(path).Length)
                        return string.Empty;
                    try
                    {
                        image1 = Image.FromFile(path, true);
                    }
                    catch (Exception ex) {}
                }
            }

            try
            {
                if (image1 != null)
                {
                    image = ImageToByte(image1);
                }
            }
            catch (Exception ex) { }

            return string.Empty;
        }

        public string GetPictureName(string id, string rayon, string tip, string format, string period, string tipBroni, string gorod)
        {
            try
            {
                SqlConnection _sqlConnection = new SqlConnection();
                _sqlConnection.ConnectionString = ConfigurationManager.ConnectionStrings["sqlConnectionString"].ToString();
                _sqlConnection.Open(); SqlDataAdapter da = new SqlDataAdapter();
                
                if (tipBroni == "3")
                {
                    // взять название района для социалки, если бронь имеет тип - социалка, 
                    // чтобы показать картинки-макеты из процесса, сделанную на социальную рекламу
                    da.SelectCommand = new SqlCommand("SELECT Rayon FROM elma3.dbo.Stendy s " +
                        string.Format(" WHERE Gorod = N'{0}' and IsSocial = 1",gorod),_sqlConnection);

                    DataSet ds1 = new DataSet();
                    da.Fill(ds1);
                    string rayonNew = null;
                    foreach (DataRow dr in ds1.Tables[0].Rows)
                    {
                        rayonNew = dr[0].ToString();
                        rayon = rayonNew;
                    }
                }


                da.SelectCommand = new SqlCommand("SELECT dv.[File] " +
                    "FROM elma3.dbo.P_OsuschestvlenieSdelki1 p, elma3.dbo.WorkflowInstance w, [Elma3].[dbo].[P_IzgotovlenieISoglasovani] i , [Elma3].[dbo].[P_IzgotovlenieISoglasovani_V] iz, [Elma3].[dbo].[File] f, elma3.dbo.Document d, elma3.dbo.DocumentVersion dv " +
                    string.Format("WHERE p.IDBron = {0} and w.ParentInstance = p.WorkflowInstance and i.WorkflowInstance = w.id and iz.Parent = i.id and f.id = iz.IzgotovlennyyMaket and d.id = f.id and d.CurrentVersion = dv.Id and iz.Rayon = N'{1}' and iz.Tip = N'{2}' and iz.Format=N'{3}' and iz.Period={4} ", id, rayon, tip, format, period), 
                    _sqlConnection);

                DataSet ds = new DataSet();
                da.Fill(ds);
                string filename = null;
                bool isFind = false;
                foreach (DataRow dr in ds.Tables[0].Rows)
                {
                    filename = dr[0].ToString();
                    isFind = true;
                }

                if (isFind == false)
                {
                    da.SelectCommand = new SqlCommand("SELECT dv.[File] " +
                        "FROM elma3.dbo.P_OsuschestvlenieSdelki1 p, elma3.dbo.WorkflowInstance w, [Elma3].[dbo].[P_IzgotovlenieISoglasovani] i , [Elma3].[dbo].[M_PIIS_IzgotovlennyyMaket1] iz, [Elma3].[dbo].[File] f, elma3.dbo.Document d, elma3.dbo.DocumentVersion dv " +
                        string.Format("WHERE p.IDBron = {0} and w.ParentInstance = p.WorkflowInstance and i.WorkflowInstance = w.id and iz.Parent = i.id and f.id = iz.Child and d.id = f.id and d.CurrentVersion = dv.Id", id), _sqlConnection);

                    ds = new DataSet();
                    da.Fill(ds);
                    filename = null;
                    foreach (DataRow dr in ds.Tables[0].Rows)
                    {
                        filename = dr[0].ToString();
                    }
                }
                _sqlConnection.Close();
                return filename;
            }
            catch (Exception ex)
            {
                return string.Empty;
            }
        }

        [WebMethod]
        public string UpdateRazm(string xmlRazm)
        {
            //XElement x = XDocument.Parse(xmlRazm).Root;
            try
            {
                SqlConnection _sqlConnection = new SqlConnection();
                _sqlConnection.ConnectionString = ConfigurationManager.ConnectionStrings["sqlConnectionString"].ToString();
                _sqlConnection.Open(); SqlDataAdapter da = new SqlDataAdapter();
                StringBuilder sb = new StringBuilder();
                // перебор размещений 
                foreach (var x in XDocument.Parse(xmlRazm).Root.Elements())
                {
                    string tip = x.Descendants("Tip").FirstOrDefault().Value;
                    string district = x.Descendants("District").FirstOrDefault().Value;
                    string format = x.Descendants("Format").FirstOrDefault().Value;
                    string period = x.Descendants("Period").FirstOrDefault().Value;
                    string idRazm = x.Descendants("IDRazm").FirstOrDefault().Value;
                    string parent = x.Descendants("Parent").FirstOrDefault().Value;
                    string xmlStend = x.Descendants("Stend").FirstOrDefault().ToString();
                    string xmlDeleted = "";
                    if (x.Descendants("Deleted").FirstOrDefault() != null)
                        xmlDeleted = x.Descendants("Deleted").FirstOrDefault().ToString();
                    if (idRazm == "-1") // нет в базе данных
                    {
                        string s1, s2, s3, s4, s5, s6, s7;
                        s1 = Guid.NewGuid().ToString();
                        s2 = x.Descendants("Tip").FirstOrDefault().Value;
                        s3 = x.Descendants("District").FirstOrDefault().Value;
                        s4 = x.Descendants("Format").FirstOrDefault().Value;
                        s5 = x.Descendants("Period").FirstOrDefault().Value;
                        s6 = x.Descendants("Parent").FirstOrDefault().Value;
                        s7 = xmlStend;

                        string s = string.Format("INSERT INTO Reservation_ParametryRazmesc (Parent, Uid, Rayon, Tip, Format, MarkStend, Period) " +
                            " VALUES({0},N'{1}',N'{2}',N'{3}',N'{4}',N'{5}',{6})",
                            s6, s1, s3, s2, s4, s7, s5);
                        da.InsertCommand = new SqlCommand(s, _sqlConnection);
                        da.InsertCommand.ExecuteNonQuery();

                        da.SelectCommand = new SqlCommand("SELECT SCOPE_IDENTITY() id", _sqlConnection);
                        DataSet ds = new DataSet();
                        da.Fill(ds);
                        sb.Clear();
                        foreach (DataRow dr in ds.Tables[0].Rows)
                        {
                            sb.Append(dr[0].ToString());
                        }

                    }
                    else if (XDocument.Parse(xmlStend).Root.Elements().Count() == 0)
                    {
                        string s = string.Format("DELETE FROM Reservation_ParametryRazmesc WHERE id = {0} ",
                            idRazm);
                        da.DeleteCommand = new SqlCommand(s, _sqlConnection);
                        da.DeleteCommand.ExecuteNonQuery();
                    }
                    else
                    {

                        string s = string.Format("UPDATE Reservation_ParametryRazmesc  SET MarkStend = N'{0}', Rayon = N'{3}', Tip=N'{4}', Format=N'{5}', Period={6} " +
                            " WHERE Parent = {1} and Id = N'{2}'",
                            xmlStend, parent, idRazm, district, tip, format, period);
                        da.UpdateCommand = new SqlCommand(s, _sqlConnection);
                        da.UpdateCommand.ExecuteNonQuery();
                    }
                    // удалить прежние размещения
                    if (xmlDeleted.Length > 0)
                    {
                        foreach (var x1 in XDocument.Parse(xmlDeleted).Root.Elements())
                        {
                            string s1 = x1.Value;
                            string s = string.Format("DELETE FROM Reservation_ParametryRazmesc WHERE id = {0} ",
                                s1);
                            da.DeleteCommand = new SqlCommand(s, _sqlConnection);
                            da.DeleteCommand.ExecuteNonQuery();
                        }
                    }

                }

                _sqlConnection.Close();
                return sb.ToString();
            }
            catch (Exception ex)
            {
                return string.Empty;
            }
        }


        [WebMethod]
        public string RetrieveProcess(int processId)
        {
            try
            {
                SqlConnection _sqlConnection = new SqlConnection();
                _sqlConnection.ConnectionString = ConfigurationManager.ConnectionStrings["sqlConnectionString"].ToString();
                _sqlConnection.Open(); SqlDataAdapter da = new SqlDataAdapter();
                da.SelectCommand = new SqlCommand("SELECT * FROM P_OsuschestvlenieSdelki1 WHERE ID = " + processId.ToString().Replace("'", "''"), _sqlConnection);

                DataSet ds = new DataSet();
                da.Fill(ds);

                StringBuilder sb = new StringBuilder();
                sb.Append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
                sb.Append("<Processes>");
                foreach (DataRow dr in ds.Tables[0].Rows)
                {
                    sb.Append("<Process>");
                    sb.Append("<ID>");
                    sb.Append(dr[0].ToString());
                    sb.Append("</ID>");
                    /*
                    sb.Append("<Name>");
                    sb.Append(dr[1].ToString());
                    sb.Append("</Name>");
                     * */
                    sb.Append("</Process>");
                }
                sb.Append("</Processes>");
                _sqlConnection.Close();

                return sb.ToString();
            }
            catch (Exception ex)
            {
                return string.Empty;
            }
        }

        [WebMethod]
        public string RetrieveUser(string userId)
        {
            try
            {
                SqlConnection _sqlConnection = new SqlConnection();
                _sqlConnection.ConnectionString = ConfigurationManager.ConnectionStrings["sqlConnectionString"].ToString();
                _sqlConnection.Open(); SqlDataAdapter da = new SqlDataAdapter();
                da.SelectCommand = new SqlCommand(string.Format("SELECT u.id, u.fullname, " +
                     " (CASE ug.name" +
                     " WHEN N'Сотрудники города Самара' THEN N'Самара'" +
                     " WHEN N'Сотрудники города Казань (Центральный Офис)' THEN N'Казань'" +
                     " WHEN N'Сотрудники города Казань (КАЗГОРЖИЛРЕКЛАМА)' THEN N'Казань'" +
                     " WHEN N'Сотрудники города Москва' THEN N'Москва'" +
                     " WHEN N'Сотрудники города Набережные Челны' THEN N'Набережные Челны'" +
                     " WHEN N'Сотрудники города Нижний Новгород' THEN N'Нижний Новгород'" +
                     " WHEN N'Сотрудники города Пермь' THEN N'Пермь'" +
                     " WHEN N'Сотрудники города Санкт-Петербург' THEN N'Санкт-Петербург'" +
                     " WHEN N'Сотрудники города Тольятти' THEN N'Тольятти'" +
                     " END) gorod," +
                     " CASE (select ug1.name from elma3.dbo.UserGroup ug1, elma3.dbo.UserGroup_User_Map mapUG1 where mapUG1.UserId = u.Id and mapUG1.GroupId = ug1.Id and ug1.name=N'Администраторы сайта бронирования') WHEN N'Администраторы сайта бронирования' THEN N'True' ELSE 'False' END, " +
                     " CASE (select ug2.name from elma3.dbo.UserGroup ug2, elma3.dbo.UserGroup_User_Map mapUG2 where mapUG2.UserId = u.Id and mapUG2.GroupId = ug2.Id and ug2.name=N'Руководители отделов продаж') WHEN N'Руководители отделов продаж' THEN N'True' ELSE 'False' END" +
                     " FROM [User] u, UserGroup ug, UserGroup_User_Map mapUG " +
                     " WHERE u.ID = {0} and mapUG.UserId = u.Id and mapUG.GroupId = ug.Id " +
                        " and (ug.Name = N'Сотрудники города Самара' " +
                        " or ug.Name = N'Сотрудники города Казань (Центральный Офис)'" +
                        " or ug.Name = N'Сотрудники города Казань (КАЗГОРЖИЛРЕКЛАМА)'" +
                        " or ug.Name = N'Сотрудники города Москва'" +
                        " or ug.Name = N'Сотрудники города Набережные Челны'" +
                        " or ug.Name = N'Сотрудники города Нижний Новгород'" +
                        " or ug.Name = N'Сотрудники города Пермь'" +
                        " or ug.Name = N'Сотрудники города Санкт-Петербург'" +
                        " or ug.Name = N'Сотрудники города Тольятти')"
                     , userId), _sqlConnection);

                DataSet ds = new DataSet();
                da.Fill(ds);

                StringBuilder sb = new StringBuilder();
                sb.Append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
                sb.Append("<Users>");
                foreach (DataRow dr in ds.Tables[0].Rows)
                {
                    sb.Append("<User>");
                    sb.Append("<ID>");
                    sb.Append(dr[0].ToString());
                    sb.Append("</ID>");
                    sb.Append("<FullName>");
                    sb.Append(dr[1].ToString());
                    sb.Append("</FullName>");
                    sb.Append("<Gorod>");
                    sb.Append(dr[2].ToString());
                    sb.Append("</Gorod>");
                    sb.Append("<IsAdmin>");
                    sb.Append(dr[3].ToString());
                    sb.Append("</IsAdmin>");
                    sb.Append("<IsROP>");
                    sb.Append(dr[4].ToString());
                    sb.Append("</IsROP>");
                    sb.Append("</User>");
                }
                sb.Append("</Users>");
                _sqlConnection.Close();

                return sb.ToString();
            }
            catch (Exception ex)
            {
                return string.Empty;
            }
        }

        [WebMethod]
        public string RetrieveRazm(string idProc)
        {
            try
            {
                SqlConnection _sqlConnection = new SqlConnection();
                _sqlConnection.ConnectionString = ConfigurationManager.ConnectionStrings["sqlConnectionString"].ToString();
                _sqlConnection.Open(); SqlDataAdapter da = new SqlDataAdapter();
                da.SelectCommand = new SqlCommand(string.Format("SELECT r.Id, r.Rayon, r.Tip, r.Format, r.MarkStend, r.Period, " +
                    " (select NazvaniePerioda from PeriodRazmescheniya p where r.Period = p.Id), " +
                    " r0.Name," +
                    " r0.TipBroni, (select u.FullName from [User] u where id = r0.[User]), r0.CreatedDate, r0.Id [Parent]," +
                    " r.IsConform" +
                    " FROM Reservation_ParametryRazmesc r, Reservation r0 WHERE Parent={0} and Parent = r0.Id ORDER BY ID DESC", idProc), _sqlConnection);
                DataSet ds = new DataSet();
                da.Fill(ds);

                StringBuilder sb = new StringBuilder();
                sb.Append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
                sb.Append("<Razm>");
                foreach (DataRow dr in ds.Tables[0].Rows)
                {
                    sb.Append("<OneRazm>");
                    sb.Append("<ID>");
                    sb.Append(dr[0].ToString());
                    sb.Append("</ID>");
                    sb.Append("<Rayon>");
                    string rayon = dr[1].ToString();
                    sb.Append(rayon);
                    sb.Append("</Rayon>");
                    sb.Append("<Tip>");
                    string tip = dr[2].ToString();
                    sb.Append(tip);
                    sb.Append("</Tip>");
                    sb.Append("<Format>");
                    string format = dr[3].ToString();
                    sb.Append(format);
                    sb.Append("</Format>");
                    sb.Append("<MarkStend>");
                    sb.Append(dr[4].ToString());
                    sb.Append("</MarkStend>");
                    sb.Append("<Period>");
                    string period = dr[5].ToString();
                    sb.Append(period);
                    sb.Append("</Period>");
                    sb.Append("<PeriodName>");
                    sb.Append(dr[6].ToString());
                    sb.Append("</PeriodName>");
                    sb.Append("<BronName>");
                    sb.Append(dr[7].ToString());
                    sb.Append("</BronName>");
                    sb.Append("<TipBroni>");
                    string tipBroni = dr[8].ToString();
                    sb.Append(tipBroni);
                    sb.Append("</TipBroni>");
                    sb.Append("<UserFIO>");
                    sb.Append(dr[9].ToString());
                    sb.Append("</UserFIO>");
                    sb.Append("<CreatedDate>");
                    sb.Append(dr[10].ToString());
                    sb.Append("</CreatedDate>");
                    sb.Append("<Parent>");
                    sb.Append(dr[11].ToString());
                    sb.Append("</Parent>");
                    sb.Append("<ImageName>");
                    sb.Append(GetPictureName(dr[11].ToString(),rayon, tip, format, period, tipBroni, ""));
                    sb.Append("</ImageName>");
                    sb.Append("<IsConform>");
                    sb.Append(dr[12].ToString());
                    sb.Append("</IsConform>");
                    sb.Append("</OneRazm>");
                }
                sb.Append("</Razm>");
                _sqlConnection.Close();

                return sb.ToString();
            }
            catch (Exception ex)
            {
                return string.Empty;
            }
        }

        [WebMethod]
        public string RetrieveRazmFilter(string gorod, string period, string tip)
        {
            try
            {
                SqlConnection _sqlConnection = new SqlConnection();
                _sqlConnection.ConnectionString = ConfigurationManager.ConnectionStrings["sqlConnectionString"].ToString();
                _sqlConnection.Open(); SqlDataAdapter da = new SqlDataAdapter();
                da.SelectCommand = new SqlCommand(string.Format("SELECT r.Id, r.Rayon, r.Tip, r.Format, r.MarkStend, r.Period, " +
                    " (select NazvaniePerioda from PeriodRazmescheniya p where r.Period = p.Id), " +
                    " r0.Name, r0.TipBroni, (select u.FullName from [User] u where id = r0.[User]), r0.CreatedDate, r0.Id [Parent]," +
                    " r.IsConform" +
                    " FROM Reservation_ParametryRazmesc r, Reservation r0 " +
                    " WHERE r.Parent=r0.Id and r0.Gorod=N'{0}' and r.Period = {1} and r.Tip = N'{2}'" +
                    " ORDER BY ID DESC", gorod, period, tip), _sqlConnection);
                DataSet ds = new DataSet();
                da.Fill(ds);

                StringBuilder sb = new StringBuilder();
                sb.Append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
                sb.Append("<Razm>");
                foreach (DataRow dr in ds.Tables[0].Rows)
                {
                    sb.Append("<OneRazm>");
                    sb.Append("<ID>");
                    sb.Append(dr[0].ToString());
                    sb.Append("</ID>");
                    sb.Append("<Rayon>");
                    string rayon = dr[1].ToString();
                    sb.Append(rayon);
                    sb.Append("</Rayon>");
                    sb.Append("<Tip>");
                    string tipT = dr[2].ToString();
                    sb.Append(tipT);
                    sb.Append("</Tip>");
                    sb.Append("<Format>");
                    string format = dr[3].ToString();
                    sb.Append(format);
                    sb.Append("</Format>");
                    sb.Append("<MarkStend>");
                    sb.Append(dr[4].ToString());
                    sb.Append("</MarkStend>");
                    sb.Append("<Period>");
                    string periodT = dr[5].ToString();
                    sb.Append(periodT);
                    sb.Append("</Period>");
                    sb.Append("<PeriodName>");
                    sb.Append(dr[6].ToString());
                    sb.Append("</PeriodName>");
                    sb.Append("<BronName>");
                    sb.Append(dr[7].ToString());
                    sb.Append("</BronName>");
                    sb.Append("<TipBroni>");
                    string tipBroni = dr[8].ToString();
                    sb.Append(tipBroni);
                    sb.Append("</TipBroni>");
                    sb.Append("<UserFIO>");
                    sb.Append(dr[9].ToString());
                    sb.Append("</UserFIO>");
                    sb.Append("<CreatedDate>");
                    sb.Append(dr[10].ToString());
                    sb.Append("</CreatedDate>");
                    sb.Append("<Parent>");
                    sb.Append(dr[11].ToString());
                    sb.Append("</Parent>");
                    sb.Append("<ImageName>");
                    string s = GetPictureName(dr[11].ToString(), rayon, tipT, format, periodT, tipBroni, gorod);
                    sb.Append(s);
                    sb.Append("</ImageName>");
                    sb.Append("<IsConform>");
                    sb.Append(dr[12].ToString());
                    sb.Append("</IsConform>");
                    sb.Append("</OneRazm>");
                }
                sb.Append("</Razm>");
                _sqlConnection.Close();

                return sb.ToString();
            }
            catch (Exception ex)
            {
                return string.Empty;
            }
        }

        [WebMethod]
        public string RetrieveBron(string UserID)
        {
            try
            {
                SqlConnection _sqlConnection = new SqlConnection();
                _sqlConnection.ConnectionString = ConfigurationManager.ConnectionStrings["sqlConnectionString"].ToString();
                _sqlConnection.Open(); SqlDataAdapter da = new SqlDataAdapter();
                da.SelectCommand = new SqlCommand(string.Format("SELECT TOP 1000 r.[Id],r.[Uid],r.[Name],r.[Gorod],r.TipBroni,r.[User],r.CreatedDate FROM [Reservation] r WHERE [User] = {0} ORDER BY ID DESC", UserID), _sqlConnection);
                DataSet ds = new DataSet();
                da.Fill(ds);

                StringBuilder sb = new StringBuilder();
                sb.Append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
                sb.Append("<Bron>");
                foreach (DataRow dr in ds.Tables[0].Rows)
                {
                    sb.Append("<Process>");
                    sb.Append("<ID>");
                    sb.Append(dr[0].ToString());
                    sb.Append("</ID>");
                    sb.Append("<UID>");
                    sb.Append(dr[1].ToString());
                    sb.Append("</UID>");
                    sb.Append("<Name>");
                    sb.Append(dr[2].ToString());
                    sb.Append("</Name>");
                    sb.Append("<Gorod>");
                    sb.Append(dr[3].ToString());
                    sb.Append("</Gorod>");
                    sb.Append("<TipBroni>");
                    sb.Append(dr[4].ToString());
                    sb.Append("</TipBroni>");
                    sb.Append("<UserID>");
                    sb.Append(dr[5].ToString());
                    sb.Append("</UserID>");
                    sb.Append("<CreatedDate>");
                    sb.Append(dr[6].ToString());
                    sb.Append("</CreatedDate>");
                    sb.Append("</Process>");
                }
                sb.Append("</Bron>");
                _sqlConnection.Close();

                return sb.ToString();
            }
            catch (Exception ex)
            {
                return string.Empty;
            }
        }

        [WebMethod]
        public string RetrieveDistrict(int gorodId, string tip)
        {
            try
            {
                SqlConnection _sqlConnection = new SqlConnection();
                _sqlConnection.ConnectionString = ConfigurationManager.ConnectionStrings["sqlConnectionString"].ToString();
                _sqlConnection.Open();
                string s = "";
                switch (gorodId)
                {
                    case 1: // Казань
                        s = string.Format("SELECT r.Id ,r.Uid,r.Rayony,t.tip,s.X,s.Y,s.IsA6Hor,s.IsSocial FROM RayonyKazanj r, TipKazanj t, Stendy s WHERE IsStend=1 and r.Rayony=s.Rayon and t.Tip=s.Tip and s.gorod=N'Казань' and s.Tip=N'{0}' ORDER BY s.IsSocial, r.Rayony", tip);
                        break;
                    case 2: // Москва
                        s = string.Format("SELECT r.Id ,r.Uid,r.Rayony,t.tip,s.X,s.Y,s.IsA6Hor,s.IsSocial FROM RayonyMoskva r, TipMoskva t, Stendy s WHERE IsStend=1 and r.Rayony=s.Rayon and t.Tip=s.Tip and s.gorod=N'Москва' and s.Tip=N'{0}' ORDER BY s.IsSocial, r.Rayony", tip);
                        break;
                    case 3: // НН
                        s = string.Format("SELECT r.Id ,r.Uid,r.Rayony,t.tip,s.X,s.Y,s.IsA6Hor,s.IsSocial FROM RayonyNizhniyNovgorod r, TipNizhniyNovgorod t, Stendy s WHERE IsStend=1 and r.Rayony=s.Rayon and t.Tip=s.Tip and s.gorod=N'Нижний Новгород' and s.Tip=N'{0}' ORDER BY s.IsSocial, r.Rayony", tip);
                        break;
                    case 4: // Пермь
                        s = string.Format("SELECT r.Id ,r.Uid,r.Rayony,t.tip,s.X,s.Y,s.IsA6Hor,s.IsSocial FROM RayonyPermj r, TipPermj t, Stendy s WHERE IsStend=1 and r.Rayony=s.Rayon and t.Tip=s.Tip and s.gorod=N'Пермь' and s.Tip=N'{0}' ORDER BY s.IsSocial, r.Rayony", tip);
                        break;
                    case 5: // Самара
                        s = string.Format("SELECT r.Id ,r.Uid,r.Rayony,t.tip,s.X,s.Y,s.IsA6Hor,s.IsSocial FROM RayonySamara r, TipSamara t, Stendy s WHERE IsStend=1 and r.Rayony=s.Rayon and t.Tip=s.Tip and s.gorod=N'Самара' and s.Tip=N'{0}' ORDER BY s.IsSocial, r.Rayony", tip);
                        break;
                    case 6: // СПб
                        s = string.Format("SELECT r.Id ,r.Uid,r.Rayony,t.tip,s.X,s.Y,s.IsA6Hor,s.IsSocial FROM RayonySanktPeterburg r, TipSanktPeterburg t, Stendy s WHERE IsStend=1 and r.Rayony=s.Rayon and t.Tip=s.Tip and s.gorod=N'Санкт-Петербург' and s.Tip=N'{0}' ORDER BY s.IsSocial, r.Rayony", tip);
                        break;
                    case 7: // Тольятти
                        s = string.Format("SELECT r.Id ,r.Uid,r.Rayony,t.tip,s.X,s.Y,s.IsA6Hor,s.IsSocial FROM RayonyToljyatti r, TipToljyatti t, Stendy s WHERE IsStend=1 and r.Rayony=s.Rayon and t.Tip=s.Tip and s.gorod=N'Тольятти' and s.Tip=N'{0}' ORDER BY s.IsSocial, r.Rayony", tip);
                        break;
                    default:
                        break;
                }
                SqlDataAdapter da = new SqlDataAdapter(s, _sqlConnection);
                DataSet ds = new DataSet();
                da.Fill(ds);

                StringBuilder sb = new StringBuilder();
                sb.Append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
                sb.Append("<Cities>");
                foreach (DataRow dr in ds.Tables[0].Rows)
                {
                    sb.Append("<City>");
                    sb.Append("<ID>");
                    sb.Append(dr[0].ToString());
                    sb.Append("</ID>");
                    sb.Append("<UID>");
                    sb.Append(dr[1].ToString());
                    sb.Append("</UID>");
                    sb.Append("<Rayony>");
                    sb.Append(dr[2].ToString());
                    sb.Append("</Rayony>");
                    sb.Append("<Tip>");
                    sb.Append(dr[3].ToString());
                    sb.Append("</Tip>");
                    sb.Append("<X>");
                    sb.Append(dr[4].ToString());
                    sb.Append("</X>");
                    sb.Append("<Y>");
                    sb.Append(dr[5].ToString());
                    sb.Append("</Y>");
                    sb.Append("<IsA6Hor>");
                    sb.Append(dr[6].ToString());
                    sb.Append("</IsA6Hor>");
                    sb.Append("<IsSocial>");
                    sb.Append(dr[7].ToString());
                    sb.Append("</IsSocial>");
                    sb.Append("</City>");
                }
                sb.Append("</Cities>");
                _sqlConnection.Close();

                return sb.ToString();
            }
            catch (Exception ex)
            {
                return string.Empty;
            }
        }

        [WebMethod]
        public string RetrieveTip(int gorodId)
        {
            try
            {
                SqlConnection _sqlConnection = new SqlConnection();
                _sqlConnection.ConnectionString = ConfigurationManager.ConnectionStrings["sqlConnectionString"].ToString();
                _sqlConnection.Open();
                string s = "";
                switch (gorodId)
                {
                    case 1: // Казань
                        s = "SELECT Id ,Uid,Tip FROM TipKazanj";
                        break;
                    case 2: // Москва
                        s = "SELECT Id ,Uid,Tip FROM TipMoskva";
                        break;
                    case 3: // НН
                        s = "SELECT Id ,Uid,Tip FROM TipNizhniyNovgorod";
                        break;
                    case 4: // Пермь
                        s = "SELECT Id ,Uid,Tip FROM TipPermj";
                        break;
                    case 5: // Самара
                        s = "SELECT Id ,Uid,Tip FROM TipSamara";
                        break;
                    case 6: // СПб
                        s = "SELECT Id ,Uid,Tip FROM TipSanktPeterburg";
                        break;
                    case 7: // Тольятти
                        s = "SELECT Id ,Uid,Tip FROM TipToljyatti";
                        break;
                    default:
                        break;
                }
                SqlDataAdapter da = new SqlDataAdapter(s, _sqlConnection);
                DataSet ds = new DataSet();
                da.Fill(ds);

                StringBuilder sb = new StringBuilder();
                sb.Append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
                sb.Append("<Types>");
                foreach (DataRow dr in ds.Tables[0].Rows)
                {
                    sb.Append("<Type>");
                    sb.Append("<ID>");
                    sb.Append(dr[0].ToString());
                    sb.Append("</ID>");
                    sb.Append("<UID>");
                    sb.Append(dr[1].ToString());
                    sb.Append("</UID>");
                    sb.Append("<Tip>");
                    sb.Append(dr[2].ToString());
                    sb.Append("</Tip>");
                    sb.Append("</Type>");
                }
                sb.Append("</Types>");
                _sqlConnection.Close();

                return sb.ToString();
            }
            catch (Exception ex)
            {
                return string.Empty;
            }
        }


        [WebMethod]
        public string RetrieveFormat(int gorodId)
        {
            try
            {
                SqlConnection _sqlConnection = new SqlConnection();
                _sqlConnection.ConnectionString = ConfigurationManager.ConnectionStrings["sqlConnectionString"].ToString();
                _sqlConnection.Open();
                string s = "";
                switch (gorodId)
                {
                    case 1: // Казань
                        s = "SELECT Id ,Uid,Format FROM FormatKazanj";
                        break;
                    case 2: // Москва
                        s = "SELECT Id ,Uid,Format FROM FormatMoskva";
                        break;
                    case 3: // НН
                        s = "SELECT Id ,Uid,Format FROM FormatNizhniyNovgorod";
                        break;
                    case 4: // Пермь
                        s = "SELECT Id ,Uid,Format FROM FormatPermj";
                        break;
                    case 5: // Самара
                        s = "SELECT Id ,Uid,Format FROM FormatSamara";
                        break;
                    case 6: // СПб
                        s = "SELECT Id ,Uid,Format FROM FormatSanktPeterburg";
                        break;
                    case 7: // Тольятти
                        s = "SELECT Id ,Uid,Format FROM FormatToljyatti";
                        break;
                    default:
                        break;
                }
                SqlDataAdapter da = new SqlDataAdapter(s, _sqlConnection);
                DataSet ds = new DataSet();
                da.Fill(ds);

                StringBuilder sb = new StringBuilder();
                sb.Append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
                sb.Append("<Formats>");
                foreach (DataRow dr in ds.Tables[0].Rows)
                {
                    sb.Append("<Formt>");
                    sb.Append("<ID>");
                    sb.Append(dr[0].ToString());
                    sb.Append("</ID>");
                    sb.Append("<UID>");
                    sb.Append(dr[1].ToString());
                    sb.Append("</UID>");
                    sb.Append("<Format>");
                    sb.Append(dr[2].ToString());
                    sb.Append("</Format>");
                    sb.Append("</Formt>");
                }
                sb.Append("</Formats>");
                _sqlConnection.Close();

                return sb.ToString();
            }
            catch (Exception ex)
            {
                return string.Empty;
            }
        }

        [WebMethod]
        public string UploadPicture(byte[] data, string HostElma, string ApplicationToken, string AuthToken)
        {
            WebClient wc = new WebClient();
            Uri serviceUri = new Uri(HostElma + "API/REST/Files/Upload");
            wc.Headers["ApplicationToken"] = ApplicationToken;
            wc.Headers["AuthToken"] = AuthToken;
            wc.Headers["Content-Type"] = "application/json";
            wc.Headers["FileName"] = "Stend.png";
            byte[] retdata = wc.UploadData(serviceUri, "POST", data);
            return UTF8Encoding.UTF8.GetString(retdata);
        }

        [WebMethod]
        public string RetrievePeriod(bool isAdmin)
        {
            try
            {
                SqlConnection _sqlConnection = new SqlConnection();
                _sqlConnection.ConnectionString = ConfigurationManager.ConnectionStrings["sqlConnectionString"].ToString();
                _sqlConnection.Open();
                string s = "getdate()";
                if (isAdmin)
                {
                    DateTime dt = DateTime.Now.AddDays(-30);
                    s = string.Format("'{0}{1}{2}'", dt.Year, dt.Month.ToString("D2"), dt.Day.ToString("D2"));
                }

                SqlDataAdapter da = new SqlDataAdapter(string.Format("SELECT Id ,Uid,NazvaniePerioda,DataNachalaPerioda,DataOkonchaniyaPerioda FROM PeriodRazmescheniya WHERE DataNachalaPerioda > {0} ORDER BY DataNachalaPerioda DESC",s), _sqlConnection);
                
                
                
                DataSet ds = new DataSet();
                da.Fill(ds);

                StringBuilder sb = new StringBuilder();
                sb.Append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
                sb.Append("<Periods>");
                foreach (DataRow dr in ds.Tables[0].Rows)
                {
                    sb.Append("<Period>");
                    sb.Append("<ID>");
                    sb.Append(dr[0].ToString());
                    sb.Append("</ID>");
                    sb.Append("<UID>");
                    sb.Append(dr[1].ToString());
                    sb.Append("</UID>");
                    sb.Append("<NazvaniePerioda>");
                    sb.Append(dr[2].ToString());
                    sb.Append("</NazvaniePerioda>");
                    sb.Append("<DataNachalaPerioda>");
                    sb.Append(dr[3].ToString());
                    sb.Append("</DataNachalaPerioda>");
                    sb.Append("<DataOkonchaniyaPerioda>");
                    sb.Append(dr[4].ToString());
                    sb.Append("</DataOkonchaniyaPerioda>");
                    sb.Append("</Period>");
                }
                sb.Append("</Periods>");
                _sqlConnection.Close();

                return sb.ToString();
            }
            catch (Exception ex)
            {
                return string.Empty;
            }
        }


    }
}
