﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using EleWise.ELMA.ComponentModel;
using EleWise.ELMA.CRM.Models;
using EleWise.ELMA.Runtime.NH.Listeners;
using NHibernate.Event;
using PostFlushEvent.Models;

namespace PostFlushEvent.Extensions
{
    [Component]
    class PostFlush : PostFlushEventListener
    {
        // событие создание объекта/документа
        public override void OnPostInsert(PostInsertEvent @event)
        {
            //    Определяем тип документа
            var fax = @event.Entity as IDocFax;
            if (fax != null)    //   интерфейс  документа  типа  Факс 
            {
                // заполняем атрибут Описание документа
                fax.Description = string.Format("Автор создания: {0}\r\n", fax.CreationAuthor.FullName);
            }
        }

        public override void OnPostUpdate(PostUpdateEvent @event)
        {
            //    Определяем  тип документа
            var fax = @event.Entity as IDocFax;
            if (fax != null)    //   интерфейс  документа  типа  Факс
            {
                fax.IzmenilDokument = string.Format("{0} в {1}", fax.ChangeAuthor, DateTime.Now.ToString(CultureInfo.InvariantCulture));
            }
        }

        public override void OnPostUpdateCollection(PostCollectionUpdateEvent @event)
        {
            var collection = @event.Collection;
            var collectionEntry = @event.Session.PersistenceContext.GetCollectionEntry(@event.Collection);
            var collectionEntries = collection.Entries(collectionEntry.LoadedPersister);

            var listChars = new List<string> { " ", "-", "(", ")" }; //Список символов,которые хотим заменять
            foreach (var entry in collectionEntries)
            {
                if (!(entry is IPhone)) continue; //Если объект коллекции телефон - продолжаем
                var phone = entry as IPhone;
                var lastNumber = phone.PhoneString;
                foreach (var str in listChars)
                {
                    lastNumber = lastNumber.Replace(str, string.Empty); //Заменяем символы из 
                }
                phone.PhoneString = lastNumber; //Пересохраняем телефон с замененными символами
            }
        }
    }
}
