﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlClient;
using System.Linq;
using System.Text;
using EleWise.ELMA.Extensions;
using EleWise.ELMA.Logging;
using EleWise.ELMA.Services;
using Permissions.Components;

namespace Permissions.Connection
{
    public static class MSSQLConnection
    {
        public static string MssqlConnectionString()
        {
            var settings = Locator.GetService<MSSQLConnectionSettingsModule>();

            if (settings.Settings.DataSource.IsNullOrWhiteSpace() ||
                settings.Settings.InitialCatalog.IsNullOrWhiteSpace() ||
                settings.Settings.UserId.IsNullOrWhiteSpace() ||
                settings.Settings.Password.IsNullOrWhiteSpace())
                return string.Empty;
            else
            {
                var connectionstring = new SqlConnectionStringBuilder()
                {
                    DataSource = settings.Settings.DataSource,
                    InitialCatalog = settings.Settings.InitialCatalog,
                    UserID = settings.Settings.UserId,
                    Password = settings.Settings.Password
                };
                return connectionstring.ToString();
            }
        }

        public static void SqlQuery(string query, Dictionary<string, object> parameters = null)
        {
            if (MssqlConnectionString().IsNullOrWhiteSpace())
                return;
            else
            {
                SqlConnection MssqlConnection = new SqlConnection(MssqlConnectionString());

                if (MssqlConnection.State == ConnectionState.Closed) //если соединение закрыто - откроем его
                    MssqlConnection.Open();

                //Создаем запрос
                using (SqlCommand deleteSqlCommand = new SqlCommand(query, MssqlConnection))
                {
                    var transaction = MssqlConnection.BeginTransaction();

                    deleteSqlCommand.Parameters.AddWithValue("SUBJECT", parameters["SUBJECT"]);
                    deleteSqlCommand.Parameters.AddWithValue("TEXT", parameters["TEXT"]);
                    deleteSqlCommand.Parameters.AddWithValue("AUTHOR", parameters["AUTHOR"]);
                    deleteSqlCommand.Transaction = transaction;

                    try
                    {
                        deleteSqlCommand.ExecuteNonQuery();
                        //для запросов, не возвращающих набор данных (insert, update, delete) надо вызывать этот метод
                        transaction.Commit(); //если вставка прошла успешно - коммитим транзакцию
                    }
                    catch (Exception exception)
                    {
                        Logger.Log.Error(exception.Message);
                        transaction.Rollback();
                    }
                    deleteSqlCommand.Dispose();
                }
            }
        }

    }
}
