﻿using System;
using EleWise.ELMA.ComponentModel;
using EleWise.ELMA.Model.Db;
using EleWise.ELMA.Runtime.Db;
using EleWise.ELMA.Runtime.Db.Migrator.Framework;
using EleWise.ELMA.Services;

namespace MyModuleDbStructure.Db
{
    [Component]
    internal class MyModuleDbStructureCs : DbStructureExtension
    {
        public override Guid ProviderUid
        {
            get { return Guid.Empty; } //Если нужно для определенной базы, например, для Firebird, то можно воспрользоваться FirebirdProvider.UID
        }
        
        public void MoveColumn()
        {
            const string tableName = "CALLS";
            const string newColumn = "KOLICHESTVOZVONKOV";
            string oldColumn = Locator.GetServiceNotNull<DbModelUpdater>().GetDeletingColumnTemporaryName(tableName, newColumn); //Старая колонка переименовывается переуд удалением, поэтому нужно получить её переименованное имя, затем переписать данные в новую колонку, затем она удалится

            var transformationProvider = Locator.GetServiceNotNull<ITransformationProvider>();
            if (transformationProvider.ColumnExists(tableName, newColumn) &&
                transformationProvider.ColumnExists(tableName, oldColumn))
            {
                transformationProvider.ExecuteNonQuery(string.Format(
                    "UPDATE {0} SET {1} = CAST({2} as varchar(255))",
                    transformationProvider.Dialect.QuoteIfNeeded(tableName),
                    transformationProvider.Dialect.QuoteIfNeeded(newColumn),
                    transformationProvider.Dialect.QuoteIfNeeded(oldColumn)));
            }
        }
   }
}
