﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Linq;
using System.Web;
using EleWise.ELMA.ComponentModel;
using EleWise.ELMA.Modules;
using EleWise.ELMA.Security;
using EleWise.ELMA.Security.Managers;
using EleWise.ELMA.Security.Models;
using EleWise.ELMA.Services;

namespace ModuleEvents.Web.Extensions
{
    [Component]
    public class ModuleEvents : IModuleEvents, IModuleContainerEvents
    {
        public IUserGroup Group()
        {
            if (UserGroupManager.Instance.Find(a => a.Name == "Группа при активации модуля").FirstOrDefault() == null)
                return null;
            else return UserGroupManager.Instance.Find(a => a.Name == "Группа при активации модуля").FirstOrDefault();
        }

        public void CreateGroups()
        {
            if (Group() == null)
            {
                var group = UserGroupManager.Instance.Create();
                group.CreationAuthor = UserManager.Instance.Load(SecurityConstants.SystemUserUid);
                group.CreationDate = DateTime.Now;
                group.Name = "Группа при активации модуля";
                group.Description = "Группа при активации модуля";
                group.Groups.Add(UserGroupManager.Instance.Load(SecurityConstants.AdminGroupUid));
                group.IsSystem = true;
                group.Save(); 
            }
        }

        public void Activated()
        {
            CreateGroups();

            var securityService = Locator.GetService<SecurityService>();
            if (securityService != null)
            {
                securityService.ResetPermissionsCache();
            }
        }

        public void Terminating() { }

        public void Installing(IWebModuleUnit module) { }

        public void Installed(IWebModuleUnit module)
        {
            CreateGroups();
        }

        public void Enabling(IWebModuleUnit module) { }

        public void Enabled(IWebModuleUnit module) { }

        public void Disabling(IWebModuleUnit module) { }

        public void Disabled(IWebModuleUnit module) { }

        public void Uninstalling(IWebModuleUnit module) { }

        public void Uninstalled(IWebModuleUnit module) { }
    }
}