﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Permissions;
using System.Web;
using System.Web.Mvc;
using EleWise.ELMA;
using EleWise.ELMA.ComponentModel;
using EleWise.ELMA.Security;
using EleWise.ELMA.Web.Mvc.Portlets;
using Microsoft.Web.Mvc.Html;
using PermissionProvider = EleWise.ELMA.Content.PermissionProvider;

namespace ModuleContainerEvents.Web.Portlet
{
    [Component]
    public class MyPortlet : Portlet<MyPortletPersonalization>
    {
        private const string UidS = "{68FDFD36-3F3A-4cd1-93ED-9398DDD268BC}";
        public static Guid UID = new Guid(UidS);
        public MyPortlet()
        {
            _profile = base.Profile as PortletProfile ?? PortletProfile.Default;
            _profile.ImageUrl = "#x16/Unk16.gif";
            _profile.Customizable = true;
        }
        /// <summary>
        /// Идентификатор портлета
        /// </summary>
        public override Guid Uid
        {
            get { return UID; }
        }

        public override MvcHtmlString Content(HtmlHelper html, MyPortletPersonalization data)
        {
            return RenderContentAction(html, "PortletView", "Home", RouteProvider.AreaName, data);
        }

        public override string Name
        {
            get { return SR.T("Мой портлет"); }
        }

        public override string Description
        {
            get { return SR.T("Описание портлета"); }
        }

        private readonly PortletProfile _profile;

        public override IPortletProfile Profile
        {
            get { return _profile; }
        }

        protected override Permission PortletPermission()
        {
            return PermissionProvider.ContentAdminPermission;
        }
    }
}