﻿using System;
using EleWise.ELMA.BPM.Web.Content.Security;
using EleWise.ELMA.ComponentModel;
using EleWise.ELMA.Content;
using EleWise.ELMA.Content.Models;
using EleWise.ELMA.Model.Managers;
using EleWise.ELMA.Modules;
using EleWise.ELMA.Runtime.NH;
using EleWise.ELMA.Security;
using EleWise.ELMA.Security.Managers;
using EleWise.ELMA.Web.Mvc.Portlets;
using EleWise.ELMA.Web.Mvc.Portlets.Layouts;
using ModuleContainerEvents.Web.Portlet;

namespace ModuleContainerEvents.Web.Extensions
{
    [Component]
    public class ModuleContainerEvents : IModuleContainerEvents
    {
        private const string UidS = "{159E131B-1F56-46ad-B31D-2A6EE573C9CF}";
        public static Guid UID = new Guid(UidS); // Гуид портлетной страницы

        public IEntityManager<IPortletPage> PageManager { get; set; }
        public PortletManager PortletManager { get; set; }
        public ISecurityService SecurityService { get; set; }
        public UserManager UserManager { get; set; }
        public IUnitOfWorkManager UnitOfWorkManager { get; set; }
        public TwoColumn5050Layout Layout { get; set; }


        public void Activated()
        {
            var admin = UserManager.Load(SecurityConstants.AdminUserUid);
            var pagecount = PageManager.Find(a => a.Uid == UID).Count;
            if (pagecount == 0)
            {
                SecurityService.RunByUser(admin,
                    () =>
                        CreateDefaultPage(admin, UID,
                            "Моя страница с портлетом"));
            }
        }

        public void Terminating()
        {

        }

        public virtual void CreateDefaultPage(EleWise.ELMA.Security.Models.IUser admin, Guid portletPageGuid,
            string portletPageName)
        {
            UnitOfWorkManager.Execute(delegate
            {
                var portletPage = PageManager.Create();
                portletPage.Uid = portletPageGuid;
                portletPage.Name = portletPageName;
                portletPage.CreationAuthor = admin;
                portletPage.PortletsLayoutId = Layout.Id;
                PageSecurity.GrandAllUsersViewPermission(portletPage);
                portletPage.Save();


                SecurityService.RunWithElevatedPrivilegies(delegate
                {
                    var portalPageDataPath = PortletsRestrictionProvider.PortalPageDataPath(portletPage);
                    var sharedPortletManager = PortletManager.Create(PersonalizationScope.Shared, portalPageDataPath);
                    
                        var portlet = PortletManager.GetPortlet(MyPortlet.UID);
                        var zone = Layout.LeftZone.Id;
                        var portletPersonalization = sharedPortletManager.AddPortlet(portlet, portalPageDataPath);
                        portletPersonalization.Zone = zone;
                        portletPersonalization.Frame = PortletFrame.Full; 
                        sharedPortletManager.SavePersonalization(portletPersonalization, portalPageDataPath);
                });
            });
        }
    }
}
