﻿using System;
using System.Collections.Generic;
using EleWise.ELMA;
using EleWise.ELMA.ComponentModel;
using EleWise.ELMA.Model.Services;
using EleWise.ELMA.Security;
using EleWise.ELMA.Security.Models;
using ModuleAccessPermissionProvider.Models;

namespace ModuleAccessPermissionProvider.Security
{
    [Component]
    public class RoleType : IPermissionRoleTypeProvider
    {
        /// <summary>
        /// Все пользователи
        /// </summary>
        public static readonly PermissionRoleType AllUsers =
            new PermissionRoleType(new Guid("58DEC298-AB48-468a-9A59-E245826A4B1F"), "Все пользователи", InterfaceActivator.TypeOf<IUserGroup>(), "#x16/User.png", "javascript:showUserGroupInfo({0});");
        
        public IEnumerable<PermissionRoleTypeStereotype> GetTypePermissionRoleStereotypes()
        {
            var organizationItem = CommonRoleTypes.OrganizationItem;
            var group = CommonRoleTypes.Group;
            var user = CommonRoleTypes.User;
            var author = CommonRoleTypes.Author;

            var allTypes = new[] { AllUsers, group, organizationItem, user, author, user };

            return new[]
                       {
                            new PermissionRoleTypeStereotype(InterfaceActivator.TypeOf<IMyObject>(), 
                               ModulePermissions.ViewItemPermission, allTypes),
                            new PermissionRoleTypeStereotype(InterfaceActivator.TypeOf<IMyObject>(), 
                               ModulePermissions.EditItemPermission, allTypes), 
                            new PermissionRoleTypeStereotype(InterfaceActivator.TypeOf<IMyObject>(), 
                               ModulePermissions.AdminPermission, new [] {author})
                       };
        }
        
        public IEnumerable<PermissionRoleType> GetRoleTypes()
        {
            return new[]
                       {
                           AllUsers
                       };
        }

        public List<string> LocalizedItemNames()
        {
            return new List<string>()
                       {
                           SR.T("Все пользователи")
                       };
        }
    }
}
