﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EleWise.ELMA.ComponentModel;
using EleWise.ELMA.Security;
using EleWise.ELMA.Services;
using ModuleAccessPermissionProvider.Models;

namespace ModuleAccessPermissionProvider.Security
{
    [Component]
    public class MyObjectPermissionsDelegate : IPermissionsDelegate
    {
        public ISecurityService SecurityService { get { return Locator.GetService<ISecurityService>(); } }

        public InstanceSettingsPermissionsDelegate DefaultInstanceSettingsPermissionsDelegate { get; set; }

        private readonly Permission[] _permissions = new[]
							{
								ModulePermissions.ViewItemPermission,
                                ModulePermissions.EditItemPermission
							};

        public bool CanCheckPermissions(Type type, Permission permission)
        {
            return typeof(IMyObject).IsAssignableFrom(type) &&
                 _permissions.Contains(permission);
        }

        public bool HasPermission(IUser user, Permission permission, object target, bool skipAdmin = false)
        {
            var obj = target as IMyObject;

            if (permission == null || obj == null)
                return false;

            if (permission.Id == ModulePermissions.ViewItemPermission.Id)
            {
                return DefaultInstanceSettingsPermissionsDelegate.HasPermission(user, permission, target);
            }

            if (permission.Id == ModulePermissions.EditItemPermission.Id)
            {
                return DefaultInstanceSettingsPermissionsDelegate.HasPermission(user, permission, target);
            }

            return false;
        }
    }
}
