﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EleWise.ELMA.ComponentModel;
using EleWise.ELMA.Security;
using EleWise.ELMA.Services;

namespace ModuleAccessPermissionProvider.Security
{
    [Component]
    class MyGlobalPermissionsDelegate : IGlobalPermissionsDelegate
    {
        public ISecurityService SecurityService { get { return Locator.GetService<ISecurityService>(); } }

        public bool HasPermission(IUser user, Permission permission, IEnumerable<Guid> userPermissionUids)
        {
            if (permission == null)
                return false;

            if (permission.Id == ModulePermissions.ModuleAccessPermission.Id)
            {
                return userPermissionUids.Contains(ModulePermissions.ModuleAccessPermission.Id);
            }

            return userPermissionUids.Contains(permission.Id);
        }
    }
}
