﻿using System.Collections.Generic;
using EleWise.ELMA;
using EleWise.ELMA.ComponentModel;
using EleWise.ELMA.Helpers;
using EleWise.ELMA.Model.Services;
using EleWise.ELMA.Security;
using EleWise.ELMA.Security.Services;
using ModuleAccessPermissionProvider.Models;

namespace ModuleAccessPermissionProvider.Security
{
    [Component]
    public class ModulePermissions : IPermissionProvider
    {
        public const string Module = __ModuleInfo.ModuleId;

        public static string ModuleName = SR.M("Ваш модуль");

        /// <summary>
        /// Идентификатор для "Доступ к Вашему модулю"
        /// </summary>
        public const string ModuleAccessPermissionId = "{184A1311-8CCF-49c6-A1C1-C11825232389}";

        /// <summary>
        /// Идентификатор для "Права на просмотр"
        /// </summary>
        public const string ViewItemPermissionId = "{81E3A934-AB85-4970-8CF4-E38913BB6DCB}";

        /// <summary>
        /// Идентификатор для "Права на редактирование"
        /// </summary>
        public const string EditItemPermissionId = "{702F4CFB-B1D4-4102-8F6A-4E36DBCED8E3}";

        /// <summary>
        /// Идентификатор для админских прав на объект
        /// </summary>
        public const string AdminPermissionId = "{2D53DE58-A90D-4fc8-A937-AFEEFDB0AFB3}";



        /// <summary>
        /// Доступ к Вашему модулю
        /// </summary>
        public static readonly Permission ModuleAccessPermission =
            new Permission(ModuleAccessPermissionId,
                            SR.M("Доступ к Вашему модулю"),
                            SR.M("Возможность работы с модулем"),
                            ModuleName,
                            moduleUid: Module
            //Можно добавить ,readOnly: true - тогда в данной привилегии будет только указанная группа.
                            );

        /// <summary>
        /// Права на просмотр
        /// </summary>
        public static readonly Permission ViewItemPermission =
            new Permission(ViewItemPermissionId,
                            SR.M("Просмотр"),
                            "",
                            SR.M("Право на просмотр записи объекта"),
                            permissionType: PermissionType.Instance,
                            entityType: InterfaceActivator.TypeOf<IMyObject>(),
                            @base: CommonPermissions.View);

        /// <summary>
        /// Права на редактирование
        /// </summary>
        public static readonly Permission EditItemPermission =
            new Permission(EditItemPermissionId,
                            SR.M("Редактирование"),
                            "",
                            SR.M("Право на редактирование записи объекта"),
                            permissionType: PermissionType.Instance,
                            entityType: InterfaceActivator.TypeOf<IMyObject>(),
                            @base: CommonPermissions.Edit);
        
        /// <summary>
        /// Админские права
        /// </summary>
        public static readonly Permission AdminPermission =
            new Permission(AdminPermissionId,
                            SR.M("Права администратора на объект"),
                             "",
                            SR.M("Полные права на объект"),
                            permissionType: PermissionType.Instance,
                            entityType: InterfaceActivator.TypeOf<IMyObject>(),
                            @base: CommonPermissions.AdminPermission);

        /// <summary>
        /// Получить список привилегий
        /// </summary>
        /// <returns></returns>
        public IEnumerable<Permission> GetPermissions()
        {
            return new[]
                       {
                           ViewItemPermission,
                           EditItemPermission,
                           ModuleAccessPermission,
                           AdminPermission
                       };
        }

        /// <summary>
        /// Получить информацию о назначении привилегий ролям по умолчанию
        /// </summary>
        /// <returns></returns>
        public IEnumerable<PermissionStereotype> GetPermissionStereotypes()
        {
            return EmptyArray<PermissionStereotype>.Instance;
        }

        public List<string> LocalizedItemsNames
        {
            get { return null; }
        }

        public List<string> LocalizedItemsDescriptions
        {
            get { return null; }
        }

        public List<string> LocalizedItemsCategories
        {
            get { return null; }
        }
    }
}
