﻿using System.Collections.Generic;
using EleWise.ELMA.ComponentModel;
using EleWise.ELMA.Security;
using EleWise.ELMA.Web.Mvc;
using ModuleAccessPermissionProvider.Models;

namespace ModuleAccessPermissionProvider.Security
{
    [Component]
    public class InstanceSettingsPermission : InstanceSettingsPermissionBase<IMyObject, IMyModuleSettings>
    {
        public InstanceSettingsPermission()
            : base(access => access.MyObject) // выражение со ссылкой на сущность
		{
		}

        protected override ICollection<IMyModuleSettings> GetPermissionHolderCollection(IMyObject target)
        {
            return target.AccessSettings; // колекция для хранения настроек привилегий
        }
    }
}
