﻿using System;
using EleWise.ELMA.ComponentModel;
using EleWise.ELMA.Model.Entities;
using EleWise.ELMA.Security;
using EleWise.ELMA.Security.Managers;
using EleWise.ELMA.Services;
using ModuleAccessPermissionProvider.Models;

namespace ModuleAccessPermissionProvider.Security
{
    [Component]
    public class DefaultPermission : IEntityInstanceDefaultPermission
    {
        public Type EntityType 
        {
            get { return typeof(IMyObject); }
        }

        /// <summary>
        /// Создать привилегии
        /// </summary>
        /// <param name="entity">Сущность</param>
        public void CreatePermissions(IEntity entity)
        {
            var obj = (IMyObject) entity;
            if (obj.AccessSettings.Count == 0)
            {

                var h = new PermissionHelper(obj);

                // Права доступа к объекту
                h.AddPermission(ModulePermissions.ViewItemPermissionId, CommonRoleTypes.Author);
                h.AddPermission(ModulePermissions.EditItemPermissionId, CommonRoleTypes.Author);

            }
        }

        private class PermissionHelper
        {

            public PermissionHelper(IMyObject myObject)
            {
                this.myObject = myObject;
            }

            public void AddPermission(string permissionId, PermissionRoleType role)
            {
                var item = new InstanceOf<IMyModuleSettings>
                {
                    New =
                    {
                        PermissionRole = role.UID,
                        MyObject = myObject,
                        PermissionId = new Guid(permissionId)
                    }
                }.New;
                if (role == CommonRoleTypes.Author)
                {
                    item.User = myObject.CreationAuthor;
                    item.TypeRoleId = CommonRoleTypes.Author.Id;
                }
                if (role == RoleType.AllUsers)
                {
                    item.Group = UserGroupManager.Instance.Load(SecurityConstants.AllUsersGroupUid);
                    item.TypeRoleId = RoleType.AllUsers.Id;
                }
                myObject.AccessSettings.Add(item);
            }

            private IMyObject myObject;

        }
    }
}
