using System;
using EleWise.ELMA.Model.Entities;
using EleWise.ELMA.Security.Models;
using EleWise.ELMA.Security.Services;

namespace ModuleAccessPermissionProvider.Models
{
    public partial class MyModuleSettings
    {
        public virtual IEntity Assigned
        {
            get
            {
                if (User != null)
                    return User;
                if (Group != null)
                    return Group;
                if (OrganizationItem != null)
                    return OrganizationItem;
                if (this.OrganizationItemEmployee != null)
                    return OrganizationItemEmployee;
                return null;
            }
            set
            {
                if (value is User)
                    User = (User)value;
                else if (value is UserGroup)
                    Group = (UserGroup)value;
                else if (value is OrganizationItem)
                {
                    var organizationItem = (OrganizationItem)value;
                    if (organizationItem.ItemType == OrganizationItemType.Position)
                        OrganizationItem = organizationItem;
                    else
                        OrganizationItemEmployee = organizationItem;
                }
                else
                    throw new ArgumentException(value.ToString());
            }
        }
        
        public virtual object Target
        {
            get { return MyObject; }
            set { MyObject = (MyObject)value; }
        }
       
       public virtual Guid TypeRoleId
        {
            get { return PermissionRole; }
            set { PermissionRole = value; }
        }
   }
}