﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EleWise.ELMA.Model.Entities;
using EleWise.ELMA.Model.Managers;
using EleWise.ELMA.Services;
using ModuleAccessPermissionProvider.Models;

namespace ModuleAccessPermissionProvider.Managers
{
    public class MyObjectManager<T, TId> : EntityManager<T, TId>
        where T : class, IMyObject, IEntity<TId>
    {
    }

    public class MyObjectManager : MyObjectManager<IMyObject, long>
    {
        /// <summary>
        /// Экземпляр менеджера
        /// </summary>
        public new static MyObjectManager Instance
        {
            get { return Locator.GetServiceNotNull<MyObjectManager>(); }
        }
    }
}
