﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EleWise.ELMA;
using EleWise.ELMA.ComponentModel;
using EleWise.ELMA.Security;
using EleWise.ELMA.Security.Services;
using NHibernate.Exceptions;

namespace ModuleAccessPermissionProvider.Extensions
{
    [Component]
    public class ModuleAccessPermission : IModuleAccessPermissionProvider, IPermissionProvider
    {
        public const string Module = __ModuleInfo.ModuleId;

        public static string ModuleName = SR.M("Ваш модуль");

        /// <summary>
        /// Идентификатор для "Доступ к Вашему модулю"
        /// </summary>
        public const string ModuleAccessPermissionId = "{184A1311-8CCF-49c6-A1C1-C11825232389}";

        /// <summary>
        /// Доступ к Вашему модулю
        /// </summary>
        public static readonly Permission ModulePermissionAccess =
            new Permission(ModuleAccessPermissionId,
                            SR.M("Доступ к Вашему модулю"),
                            SR.M("Возможность работы с модулем"),
                            ModuleName,
                            moduleUid: Module
                            //Можно добавить ,readOnly: true - тогда в данной привилегии будет только указанная группа.
                            );

        
        /// <summary>
        /// Идентификатор для "Права на просмотр"
        /// </summary>
        public const string ViewItemPermissionId = "{81E3A934-AB85-4970-8CF4-E38913BB6DCB}";

        /// <summary>
        /// Права на просмотр
        /// </summary>
        public static readonly Permission ViewItemPermission =
            new Permission(ViewItemPermissionId,
                            SR.M("Права на просмотр записи"),
                            SR.M("Возможность просмотра записи"),
                            ModuleName,
                            moduleUid: Module
            //Можно добавить ,readOnly: true - тогда в данной привилегии будет только указанная группа.
                            );
         
        
        /// <summary>
        /// Получить словарь из значений "Идентификатор модуля->Привилегия доступа к модулю"
        /// </summary>
        /// <returns></returns>
        public Dictionary<string, Permission> GetModuleAccessPermissions()
        {
            return new Dictionary<string, Permission> { { Module, ModulePermissionAccess } };
        }

        /// <summary>
        /// Получить список привилегий
        /// </summary>
        /// <returns></returns>
        public IEnumerable<Permission> GetPermissions()
        {
            return new[]
                       {
                           ModulePermissionAccess
                       };
        }

        /// <summary>
        /// Получить информацию о назначении привилегий ролям по умолчанию
        /// </summary>
        /// <returns></returns>
        public IEnumerable<PermissionStereotype> GetPermissionStereotypes()
        {
            return new[]
			{
				new PermissionStereotype(
					new[] 
                    {
                        ModulePermissionAccess
					},
					SecurityConstants.AdminGroupDescriptor)
			};
        }

        public List<string> LocalizedItemsNames
        {
            get { return null; }
        }

        public List<string> LocalizedItemsDescriptions
        {
            get { return null; }
        }

        public List<string> LocalizedItemsCategories
        {
            get { return null; }
        }
    }
}
