﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EleWise.ELMA.ComponentModel;
using EleWise.ELMA.Model.Entities;
using EleWise.ELMA.Security;
using EleWise.ELMA.Services;
using ModuleAccessPermissionProvider.Models;

namespace ModuleAccessPermissionProvider.Extensions
{
    [Component]
    public class DefaultPermission : IEntityInstanceDefaultPermission
    {
        public Type EntityType 
        {
            get { return typeof(IMyObject); }
        }

        /// <summary>
        /// Создать привилегии
        /// </summary>
        /// <param name="entity">Сущность</param>
        public void CreatePermissions(IEntity entity)
        {
            var obj = (IMyObject) entity;
            obj.AccessSettings.Add(new InstanceOf<IMyModuleSettings>
            {
                New = 
                {
                    Target = obj,
                    PermissionId = ModuleAccessPermission.ViewItemPermission.Id,
                    User = obj.CreationAuthor
                }
            }.New);
        }
    }
}
