﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using EleWise.ELMA;
using EleWise.ELMA.ComponentModel;
using EleWise.ELMA.Web.Content;
using EleWise.ELMA.Web.Content.Menu;
using EleWise.ELMA.Web.Mvc.ExtensionPoints;

namespace ModuleAccessPermissionProvider.Web.Menu
{
    [Component]
    public class MyObjectMenu : IMenuItemsProvider
    {
        public const string PosterServiceListMenuItemCode = "ModuleAccessPermissionProvider.Web.Controllers.HomeController";
        public const string Poster = "Poster";

        public void Items(MenuItemFactory factory)
        {
            factory.With(f => f.Container("left"));

            factory.Section(SR.T("Мой модуль"), Poster)
                .Order(95)
                .Container("left")
                .Image24("#x24/Unk24.gif")
                .OnTop(true)
                .Stretch(true);

            factory.Action(new ActionRoute("Grid", "Home", new { area = RouteProvider.AreaName }), ObjectIconFormat.x16)
                .Name(SR.M("Список записей объекта"))
                .Parent(Poster)
                .Order(10)
                .Container("left");
        }

        public List<string> LocalizedItemsNames 
        {
            get
            {
                return new List<string> { 
                SR.T("Ваш модуль")
            };
            }
        }

        public List<string> LocalizedItemsDescriptions
        {
            get { return null; }
        }
    }
}