﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using EleWise.ELMA.BPM.Mvc.Controllers;
using EleWise.ELMA.BPM.Web.Common.Models;
using EleWise.ELMA.BPM.Web.Security.ExtensionPoints;
using EleWise.ELMA.ComponentModel;
using EleWise.ELMA.Model.Services;
using EleWise.ELMA.Security;
using EleWise.ELMA.Security.Managers;
using EleWise.ELMA.Services;
using EleWise.ELMA.Web.Content;
using EleWise.ELMA.Web.Content.Menu;
using EleWise.ELMA.Web.Mvc.Security;
using ModuleAccessPermissionProvider.Managers;
using ModuleAccessPermissionProvider.Models;
using ModuleAccessPermissionProvider.Security;
using Telerik.Web.Mvc;

namespace ModuleAccessPermissionProvider.Web.Controllers
{

    public class HomeController : EleWise.ELMA.BPM.Mvc.Controllers.BPMController<IMyObject, long>
    {
        protected IMyObjectFilter CreateFilter()
        {
            return new InstanceOf<IMyObjectFilter>().New;
        }

        [ContentItem]
        [Permission(ModulePermissions.ModuleAccessPermissionId)]
        public ActionResult View()
        {
            return View(); 
        }

        [ContentItem]
        [Permission(ModulePermissions.ModuleAccessPermissionId)]
        public ActionResult Grid()
        {
            var filter = CreateFilter();
            var data = CreateGridData(new GridCommand(), filter);
            return View(data);
        }

        public ActionResult ViewItem(long id)
        {
            var model = MyObjectManager.Instance.Load(id);
            return View(model);
        }



    }
}
