﻿using System;
using System.Collections.Generic;
using EleWise.ELMA.ComponentModel;
using EleWise.ELMA.Messaging;
using MessageChannel.Connection;
using EleWise.ELMA.Security.Models;

namespace MessageChannel.Extensions
{
    [Component]
    public class MessageChannelDb : IMessageChannel
    {
        private readonly Guid _uid = new Guid("{FA1B0A61-B3F6-4f16-A57F-9D6253710D50}");
        public Guid Uid
        {
            get { return _uid; }
        }

        public string Name
        {
            get { return "DBChannelMessage"; }
        }

        public string DisplayName
        {
            get { return "Канал отправки сообщений в БД"; }
        }

        public bool Default
        {
            get { return true; }
        }

        public void Send(IMessage message)
        {
            //Проверка на наличие сообщения
            if (message == null) throw new ArgumentNullException("message");

            //Проверка получателя
            var recipient = message.Recipient as IUser;
            if (recipient == null)
            {
                return;
            }
            var author = message.Author as IUser;
            if (author == null)
            {
                return;
            }

            Dictionary<string, object> parameters = new Dictionary<string, object>();
            parameters.Add("SUBJECT", message.Subject);
            parameters.Add("RECIPIENT", recipient.Id);
            parameters.Add("TEXT", message.FullMessageText);
            parameters.Add("AUTHOR", author.Id);


            FireBirdConnection.SqlQuery("insert into MESSAGES (ID, SUBJECT, RECIPIENT, TEXT, \"DATE\", AUTHOR) values (gen_id(GEN_MESSAGES_ID, 1), @SUBJECT, @RECIPIENT, @TEXT, current_timestamp, @AUTHOR)",
                                        parameters);
        }
    }
}
