﻿using System;
using System.IO;
using EleWise.ELMA.ComponentModel;
using EleWise.ELMA.Messaging;
using EleWise.ELMA.Runtime;
using EleWise.ELMA.Security;
using EleWise.ELMA.Services;

namespace MessageChannel.Extensions
{
    [Component]
    public class MessageChannel : IMessageChannel
    {
        private readonly Guid _uid = new Guid("{B2D745F9-9624-40c4-9C07-ABF44281F066}");
        public Guid Uid
        {
            get { return _uid; }
        }

        public string Name
        {
            get { return "TextFileChannel"; }
        }

        public string DisplayName
        {
            get { return "Канал отправки сообщений в текстовые файлы"; }
        }

        public bool Default
        {
            get { return true; }
        }

        private static readonly string Filepath = Locator.GetServiceNotNull<IRuntimeApplication>().Configuration.Config.FilePath;
        private static readonly string Fullpath = Path.GetDirectoryName(Filepath);
        private static readonly string HeadDir = Path.Combine(Fullpath, "Messages");

        public void Send(IMessage message)
        {
            //Проверка на наличие сообщения
            if (message == null) throw new ArgumentNullException("message");

            //Проверка получателя
            var recipient = message.Recipient as IUser;
            if (recipient == null)
            {
                return;
            }

            string recipientDir = Path.Combine(HeadDir, recipient.ToString());
            if (!Directory.Exists(HeadDir))
                Directory.CreateDirectory(HeadDir);
            if (!Directory.Exists(recipientDir))
                Directory.CreateDirectory(recipientDir);
            string path = Path.Combine(recipientDir, string.Format("{0}_{1}-{2}-{3}.{4}.txt",
                                    DateTime.Now.ToShortDateString(),
                                    DateTime.Now.Hour,
                                    DateTime.Now.Minute,
                                    DateTime.Now.Second,
                                    DateTime.Now.Millisecond));
            if (!File.Exists(path))
            {
                using (StreamWriter file1 =
                    new StreamWriter(path, true))
                {
                    file1.WriteLine("Тема: {0}\r\n Текст сообщения: {1}", message.Subject, message.FullMessageText);
                }
            }
        }
    }
}
