﻿using System;
using System.Collections.Generic;
using System.Linq;
using EleWise.ELMA.ComponentModel;
using EleWise.ELMA.Messaging;
using EleWise.ELMA.Security.Models;
using MessageChannel.Connection;

namespace MessageChannel.Extensions
{
    [Component]
    public class GroupingMessageChannel : IGroupingMessageChannel
    {
        private readonly Guid _uid = new Guid("{F2E1B073-DADA-4b13-805C-FE2CE3FA9375}");

        public Guid Uid
        {
            get { return _uid; }
        }

        public string Name
        {
            get { return "DBGropingMessageChannel"; }
        }

        public string DisplayName
        {
            get { return "Канал отправки сообщений в БД одной транзакцией"; }
        }

        public bool Default
        {
            get { return true; }
        }

        public void Send(IMessage message)
        {
            var recipient = message.Recipient as IUser;
            if (recipient == null)
            {
                return;
            }
            Send(message, new[] {recipient});
        }

        public void Send(IMessage message, IEnumerable<EleWise.ELMA.Security.IUser> recipients)
        {
            //Проверка на наличие сообщения
            if (message == null) throw new ArgumentNullException("message");

            var recUsers = recipients as IUser[] ?? recipients.ToArray();
            if (recUsers.Length == 0) return;

            var author = message.Author as IUser;
            if (author == null)
            {
                return;
            }

            var parameters = new Dictionary<string, object>
            {
                {"SUBJECT", message.Subject},
                {"TEXT", message.FullMessageText},
                {"AUTHOR", author.Id}
            };

            string query = string.Empty;

            foreach (IUser recipient in recUsers)
            {
                query +=
                    string.Format(
                        "insert into MESSAGES (SUBJECT, RECIPIENT, TEXT, DATE, AUTHOR) values (@SUBJECT, {0}, @TEXT, current_timestamp, @AUTHOR) ",
                        recipient.Id);
            }
            MssqlConnection.SqlQuery(query, parameters);
        }
    }
}