﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlClient;
using EleWise.ELMA.Logging;

namespace MessageChannel.Connection
{
    public static class MssqlConnection
    {
        //Формируем строку подключения
        private static readonly string MssqlconnectionString = new SqlConnectionStringBuilder
        {
            DataSource = "(local)",
            UserID = "sa",
            Password = "!Q2w3e4r5t",
            InitialCatalog = "BASEMESSAGES"
        }.ToString();

        private static readonly SqlConnection SqlConnection = new SqlConnection(MssqlconnectionString);

        public static void SqlQuery(string query, Dictionary<string, object> parameters = null)
        {
            if (SqlConnection.State == ConnectionState.Closed) //если соединение закрыто - откроем его
                SqlConnection.Open();

            //Создаем запрос
            using (var sqlCommand = new SqlCommand(query, SqlConnection))
            {
                var transaction = SqlConnection.BeginTransaction();

                if (parameters != null)
                {
                    foreach (var items in parameters)
                    {
                        sqlCommand.Parameters.AddWithValue(items.Key, items.Value);
                    }
                }
                sqlCommand.Transaction = transaction;

                try
                {
                    sqlCommand.ExecuteNonQuery(); //для запросов, не возвращающих набор данных (insert, update, delete) надо вызывать этот метод
                    transaction.Commit(); //если вставка прошла успешно - коммитим транзакцию
                }
                catch (Exception exception)
                {
                    Logger.Log.Error(exception.Message);
                    transaction.Rollback();
                }
            }
        }

    }
}