﻿using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using EleWise.ELMA.Logging;
using EleWise.ELMA.Runtime;
using EleWise.ELMA.Services;
using FirebirdSql.Data.FirebirdClient;

namespace MessageChannel.Connection
{
    public static class FireBirdConnection
    {
        private static readonly string Filepath = Locator.GetServiceNotNull<IRuntimeApplication>().Configuration.Config.FilePath; //Путь до файла конфигурации
        private static readonly string HeadDir = Path.GetDirectoryName(Filepath); //Директория файла конфигурации
        private const string DbName = "BASEMESSAGES.FDB"; //Имя базы данных

        //Формируем строку подключения
        private static readonly string Fbconnection = new FbConnectionStringBuilder
                {
                    DataSource = "127.0.0.1",
                    UserID = "sysdba",
                    Password = "masterkey",
                    Port = 3056,
                    Dialect = 3,
                    ServerType = 0,
                    Database = Path.Combine(HeadDir, DbName),
                    Charset = "UNICODE_FSS"
                }.ToString();

        private readonly static FbConnection Fb = new FbConnection(Fbconnection);

        public static void SqlQuery(string query, Dictionary<string, object> parameters = null)
        {
            if (Fb.State == ConnectionState.Closed) //если соединение закрыто - откроем его
                Fb.Open();

            //Создаем запрос
            using (var fbCommand = new FbCommand(query, Fb))
            {
                var fbt = Fb.BeginTransaction();

                if (parameters != null)
                {
                    foreach (var items in parameters)
                    {
                        fbCommand.Parameters.AddWithValue(items.Key, items.Value);
                    }
                }
                fbCommand.Transaction = fbt;

                try
                {
                    fbCommand.ExecuteNonQuery(); //для запросов, не возвращающих набор данных (insert, update, delete) надо вызывать этот метод
                    fbt.Commit(); //если вставка прошла успешно - коммитим транзакцию
                }
                catch (Exception exception)
                {
                    Logger.Log.Error(exception.Message);
                    fbt.Rollback();
                }
            }
        }
    }
}
