﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using EleWise.ELMA.BPM.Mvc.Controllers;
using System.Web.Mvc;

namespace EleWise.ELMA.IntegrationLdap.Web.Controllers
{

    /// <summary>
    /// Контроллер для настройки интеграции LDAp
    /// </summary>
    public class IntegrationLdapSettingsController : BPMController
    {

        #region Imported Services

        /// <summary>
        /// Модуль настроек
        /// </summary>
        public IntegrationLdapSettingsModule SettingsModule { get; set; }

        /// <summary>
        /// Настройки
        /// </summary>
        public IntegrationLdapSettings Settings
        {
            get
            {
                return SettingsModule.Settings;
            }
        }

 
        #endregion


        #region Actions

        /// <summary>
        /// Просмотр настроек
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public ActionResult View()
        {
            return PartialView(Settings);
        }

        /// <summary>
        /// Редактирование настроек
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public ActionResult Edit()
        {
            return PartialView(Settings);
        }

        #endregion

    }
}