﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Mvc.Html;
using EleWise.ELMA.ComponentModel;
using EleWise.ELMA.Web.Mvc.Models.Settings;

namespace EleWise.ELMA.IntegrationLdap.Web.Components
{
    
    [Component(Order = 200)]
    public class IntegrationLdapSettingsModuleController : GlobalSettingsModuleControllerBase<IntegrationLdapSettings, IntegrationLdapSettingsModule>
    {
        #region Overrides of GlobalSettingsModuleBase<IntegrationLdapSettings>

        public IntegrationLdapSettingsModuleController(IntegrationLdapSettingsModule module)
            : base(module)
        {
        }

        public override MvcHtmlString RenderDisplay(HtmlHelper html)
        {
            return html.Action("View", "IntegrationLdapSettings", new { area = RouteProvider.AreaName });
        }

        public override MvcHtmlString RenderEdit(HtmlHelper html)
        {
            return html.Action("Edit", "IntegrationLdapSettings", new { area = RouteProvider.AreaName });
        }

        #endregion

    }
}