﻿using System;
using System.Collections.Generic;
using System.Web.Mvc;
using System.Web.Mvc.Html;
using EleWise.ELMA.BPM.Web.Common.ExtensionPoints;
using EleWise.ELMA.ComponentModel;
using EleWise.ELMA.Model.Entities.EntityReferences;
using EleWise.ELMA.Model.Services;
using EleWise.ELMA.Projects.Models;
using EleWise.ELMA.Web.Mvc.Html;

namespace LastObjectView.Web.Extensions
{
    [Component]
    public class ProjectLastObjectRenderer : ILastObjectRenderer
    {
        public Guid TypeUid
        {
            get { return InterfaceActivator.UID<IProject>(); }
        }

        public MvcHtmlString Render(HtmlHelper helper, ReferenceOnEntity entity)
        {
            return helper.Partial("LastObjectProject", entity.Object);
        }

        public bool HasContextMenu(ReferenceOnEntity entity)
        {
            return true;
        }

        public void RenderContextMenu(HtmlHelper helper, ReferenceOnEntity entity)
        {
            helper.RegisterContent("ProjectOperations", (d) => helper.Partial("ProjectOperations", entity.Object));
        }

        public string ContextMenuName
        {
            get { return "ProjectContextMenu"; }
        }

        public List<string> NotVisibleItems(HtmlHelper helper, ReferenceOnEntity entity)
        {
            return null;
        }
    }
}