﻿using System;
using EleWise.ELMA;
using EleWise.ELMA.Common.Managers;
using EleWise.ELMA.ComponentModel;
using EleWise.ELMA.ExtensionPoints;
using EleWise.ELMA.Model.Entities;
using EleWise.ELMA.Model.Entities.EntityReferences;
using EleWise.ELMA.Model.Services;
using EleWise.ELMA.Projects.Models;

namespace LastObjectView.Web.Extensions
{
    [Component]
    public class LastObjectProvider : ILastObjectProvider
    {
        public Guid TypeUid
        {
            get { return InterfaceActivator.UID<IProject>(); }
        }

        public string DisplayName
        {
            get { return SR.T("Проекты"); }
        }

        public void AddInfo(IEntity<long> entity)
        {
            LastObjectInfoManager.Instance.AddInfo(new ReferenceOnEntity
            {
                ObjectTypeUId = TypeUid,
                ObjectId = entity.Id
            });
        }

        public void RemoveInfo(IEntity<long> entity)
        {
            LastObjectInfoManager.Instance.RemoveInfo(new ReferenceOnEntity
            {
                ObjectTypeUId = TypeUid,
                ObjectId = entity.Id
            });
        }
    }
}