﻿using System;
using System.Text.RegularExpressions;
using System.Web.UI;
using System.Web.UI.WebControls.WebParts;
using Microsoft.SharePoint;
using Microsoft.SharePoint.Administration;
using Microsoft.SharePoint.WebControls;
using Microsoft.SharePoint.WebPartPages;

namespace ElmaWebParts.PortletsWebPart
{
    public partial class PortletsWebPartUserControl : UserControl
    {
        public PortletsWebPart WebPart { get; set; }

        protected void Page_Load(object sender, EventArgs e)
        {
        }


        protected override void OnPreRender(EventArgs e)
        {
            base.OnPreRender(e);
            if (WebPart != null)
            {
                portletUID.Value = WebPart.PortletUID;
                portletTitle.Value = WebPart.Title;

                elmaUrlPanel.Visible = step1.Visible = step2.Visible = false;
                if (!String.IsNullOrEmpty(WebPart.ElmaUrl))
                {
                    this.Page.ClientScript.RegisterClientScriptInclude("ElmaWebPart.Postmessage.js", WebPart.ElmaUrl + "/Scripts/Utils/postmessage.js");
                    this.Page.ClientScript.RegisterClientScriptInclude("ElmaWebPart.ELMA.Gadget.js", WebPart.ElmaUrl + "/Modules/EleWise.ELMA.BPM.Web.Content/Scripts/ELMA.Gadget.js");
                }
                if (String.IsNullOrEmpty(WebPart.ElmaUrl))
                {
                    elmaUrlPanel.Visible = true;
                }
                else if (String.IsNullOrEmpty(WebPart.PortletUID) || String.IsNullOrEmpty(WebPart.InstanceUID) || String.IsNullOrEmpty(WebPart.Path))
                {
                    step1.Visible = true;
                }
                else
                {
                    step2.Visible = true;
                }
            }
        }

        protected void SaveStep1Save_Click(object sender, EventArgs e)
        {
            if (!String.IsNullOrEmpty(portletUID.Value) && !String.IsNullOrEmpty(portletPath.Value) && !String.IsNullOrEmpty(portletInstanceUID.Value) && !String.IsNullOrEmpty(portletTitle.Value))
            {
                WebPart.PortletUID = portletUID.Value;
                WebPart.Title = portletTitle.Value;
                WebPart.InstanceUID = portletInstanceUID.Value;
                WebPart.Path = portletPath.Value;
                SavePropertes(null, portletUID.Value, portletTitle.Value, portletInstanceUID.Value, portletPath.Value);
            }
        }

        private void SavePropertes(string url, string uid, string title, string iuid, string path)
        {
            SPContext.Current.Web.AllowUnsafeUpdates = true;
            WebPartManager partMgr = WebPartManager.GetCurrentWebPartManager(Page);
            using (SPLimitedWebPartManager mgr = SPContext.Current.Web.GetLimitedWebPartManager(Page.Request.Url.ToString(), partMgr != null ? partMgr.Personalization.Scope : PersonalizationScope.User))
            {
                var wp = mgr.WebParts[WebPart.ID] as PortletsWebPart;
                if (wp != null)
                {
                    if (!String.IsNullOrEmpty(url))
                        wp.ElmaUrl = url;
                    if (!String.IsNullOrEmpty(uid))
                        wp.PortletUID = uid;
                    if (!String.IsNullOrEmpty(iuid))
                        wp.InstanceUID = iuid;
                    if (!String.IsNullOrEmpty(path))
                        wp.Path = path;
                    if (!String.IsNullOrEmpty(title))
                        wp.Title = title;
                    mgr.SaveChanges(wp);
                }
            }
            SPContext.Current.Web.AllowUnsafeUpdates = false;            
        }

    }
}
