﻿using System.ComponentModel;
using System.Web.UI;
using System.Web.UI.WebControls.WebParts;

namespace ElmaWebParts.PortletsWebPart
{
    [ToolboxItem(false)]
    public class PortletsWebPart : WebPart
    {
        private string _elmaUrl = string.Empty;
        private string _portletUID = string.Empty;
        private string _path = string.Empty;
        private string _instanceUID = string.Empty;

        [Personalizable(), WebDisplayName("Адрес сервера ELMA"), WebBrowsable(true), Category("ELMA")]
        public string ElmaUrl
        {
            get { return _elmaUrl; }
            set { _elmaUrl = value; }
        }

        [Personalizable(), WebDisplayName("UID портлета"), WebBrowsable(false)]
        public string PortletUID
        {
            get { return _portletUID; }
            set { _portletUID = value; }
        }

        [Personalizable(), WebDisplayName("Путь портлета"), WebBrowsable(false)]
        public string Path
        {
            get { return _path; }
            set { _path = value; }
        }

        [Personalizable(), WebDisplayName("UID экземпляра портлета"), WebBrowsable(false)]
        public string InstanceUID
        {
            get { return _instanceUID; }
            set { _instanceUID = value; }
        }

        // Visual Studio might automatically update this path when you change the Visual Web Part project item.
        private const string _ascxPath = @"~/_CONTROLTEMPLATES/ElmaWebParts/PortletsWebPart/PortletsWebPartUserControl.ascx";

        protected override void CreateChildControls()
        {
            PortletsWebPartUserControl control = Page.LoadControl(_ascxPath) as PortletsWebPartUserControl;
            if (control != null)
            {
                control.WebPart = this;
                Controls.Add(control);
            }
        }
    }
}
