﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Routing;
using EleWise.ELMA.ComponentModel;
using EleWise.ELMA.CRM;
using EleWise.ELMA.CRM.Models;
using EleWise.ELMA.Helpers;
using EleWise.ELMA.Model.Services;
using EleWise.ELMA.Web.Mvc.ExtensionPoints;
using EntityLink.Models;

namespace EntityLink.Web.Extensions
{
    [Component]
    public class ObjectLinkExtension : IObjectLink
    {
        public bool CheckType(Type type)
        {
            return type.IsInheritOrSame<DeliveryCalendarItem>();
        }

        public string Url(RequestContext context, object obj)
        {
            var urlHelper = new UrlHelper(context);
            return urlHelper.Action("ViewItem", "Catalogs", new
            {
                area = EleWise.ELMA.BPM.Web.Common.RouteProvider.AreaName,
                id = ((DeliveryCalendarItem)obj).Id,
                uid = InterfaceActivator.UID<IDelivery>()
            });
        }
    }

}