﻿using System;
using System.Web.Mvc;
using System.Web.Routing;
using EleWise.ELMA.ComponentModel;
using EleWise.ELMA.Model.Entities;
using EleWise.ELMA.Model.Services;
using EleWise.ELMA.Web.Mvc.ExtensionPoints;
using EntityLink.Models;

namespace EntityLink.Web.Extensions
{
    [Component]
    public class EntityLinkExtension : IEntityLink
    {
        public Type EntityType
        {
            get { return typeof(IMyObject); }
        }

        public Guid TypeUid
        {
            get { return Guid.Empty; }
        }

        public string Area(IEntity entity)
        {
            return null; //RouteProvider.AreaName;
        }

        public string Action(IEntity entity)
        {
            return null; //"Entity";
        }

        public string Controller(IEntity entity)
        {
            return null; //"Home";
        }

        public string IdParam
        {
            get { return null; }
        }

        public RouteValueDictionary GetParams(IEntity entity)
        {
            return null;
        }

        public string Href(RequestContext html, IEntity entity)
        {
            var urlHelper = new UrlHelper(html);
            return urlHelper.Action("Entity", "Home", new { area = EntityLink.Web.RouteProvider.AreaName, id = entity.GetId().ToString() });
        }

        public bool LoadEntityIfNull
        {
            get { return true; }
        }
    }
}