﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Script.Serialization;
using EleWise.ELMA.Calendar;
using EleWise.ELMA.Calendar.Models;
using EleWise.ELMA.Model.Services;
using EleWise.ELMA.Security.Models;
using EleWise.ELMA.Extensions;
using EntityLink.Models;

namespace EntityLink.Web.Extensions
{
    [Serializable]
    public class DeliveryCalendarItem : ICalendarItem
    {
        [ScriptIgnore]
        public readonly IDelivery Delivery;

        public DeliveryCalendarItem(IDelivery delivery, IUser currentUser = null)
        {
            if (delivery == null)
                throw new ArgumentNullException("delivery");

            Delivery = delivery;
            StartDate = delivery.StartDate;
            EndDate = delivery.FinishDate;
            Completed = delivery.IsComplete == true;
            Theme = delivery.Name;
            Place = delivery != null ? delivery.Adress : "";
            Description = "";
            HasCopy = true;
            OnlyInfo = false;
            CreationAuthor = delivery.CreationAuthor.Id;
            ReadOnly = false;

            var users = new List<IUser> { delivery.Executor };
            if (delivery.InformTo.Any())
                users.AddRange(delivery.InformTo);
            EventUsers = users.Distinct((a, b) => a.Id == b.Id, c => c.Id.GetHashCode()).ToDictionary(u => u.Id.ToString(), u => u.GetShortName());
        }

        public string Id
        {
            get { return Delivery.Id.ToString(); }
        }

        public string SourceId { get { return Delivery.Id.ToString(); } }
        public Guid SourceTypeUid { get { return InterfaceActivator.UID<IDelivery>(); } }
        public DateTime StartDate { get; set; }
        public DateTime EndDate { get; set; }
        public DateTime? LimitStartDate { get; set; }
        public DateTime? LimitEndDate { get; set; }
        public CalendarEventPeriod Period { get; set; }
        public bool Completed { get; set; }

        public bool MarkExpired
        {
            get { return false; }
        }

        public bool ToInform { get; private set; }
        public string Theme { get; set; }
        public string Place { get; set; }
        public string To { get; set; }
        public IDictionary<string, string> EventUsers { get; set; }
        public string Description { get; set; }
        public bool Periodical { get; private set; }
        public ICalendarItem Template { get; set; }
        public bool HasCopy { get; set; }

        public bool OnlyInfo { get; set; }
        public long CreationAuthor { get; set; }
        public bool ReadOnly { get; set; }

        public ICalendarItem Clone()
        {
            return new DeliveryCalendarItem(Delivery);
        }

        public ICollection<EleWise.ELMA.Common.Models.IComment> Comments
        {
            get { return null; }
        }

        public bool PrivateAccess { get { return false; } }
    }

}