﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using EleWise.ELMA.Calendar;
using EleWise.ELMA.Calendar.Managers;
using EleWise.ELMA.Calendar.Models;
using EleWise.ELMA.ComponentModel;
using EleWise.ELMA.Model.Common;
using EleWise.ELMA.Model.Managers;
using EleWise.ELMA.Model.Ranges;
using EleWise.ELMA.Security;
using EleWise.ELMA.Security.Services;
using EleWise.ELMA.Services;
using EleWise.ELMA.Tasks.Models;
using EntityLink.Managers;
using EntityLink.Models;
using IUser = EleWise.ELMA.Security.Models.IUser;
using PermissionProvider = EleWise.ELMA.Tasks.PermissionProvider;

namespace EntityLink.Web.Extensions
{
    [Component]
    public class CalendarItemProvider : ICalendarItemProvider
    {
        private readonly Guid _uid = new Guid("{03B3D20A-0807-4b20-B1FC-819833399602}");

        private IDeliveryFilter GetFilter(ICollection<ISchedule> schedules, DateTime startDate, DateTime endDate)
        {
            return new InstanceOf<IDeliveryFilter>
            {
                New =
                {
                    FinishDate = new DateTimeRange { From = startDate, To = endDate }
                }
            }.New;
        }

        private IUser CurrentUser
        {
            get { return AuthenticationService.GetCurrentUser<IUser>(); }
        }

        public DeliveryManager DeliveryManager { get; set; }
        public ScheduleManager ScheduleManager { get; set; }
        public ISecurityService SecurityService { get; set; }
        public IEntityManager<ITaskTimePlan, long> TaskTimePlanManager { get; set; }

        public Guid Uid
        {
            get { return _uid; }
        }

        public ICollection<ICalendarItem> GetItems(IUser user, DateTime startDate, DateTime endDate,
            bool checkPermission = true, bool showExpired = false)
        {

            return GetItems(ScheduleManager.GetUserSchedule(user), startDate, endDate, checkPermission, showExpired);
        }

        public ICollection<ICalendarItem> GetItems(ISchedule schedule, DateTime startDate, DateTime endDate,
            bool checkPermission = true, bool showExpired = false)
        {
            return schedule.Owner != null ? GetItems(new List<ISchedule> { schedule }, startDate, endDate, checkPermission, showExpired) : new List<ICalendarItem>();
        }

        public ICollection<ICalendarItem> GetItems(ICollection<ISchedule> schedules, DateTime startDate,
            DateTime endDate, bool checkPermission = true, bool showExpired = false)
        {
            if (schedules.All(s => s.Owner == null))
                return new List<ICalendarItem>();

            var filter = GetFilter(schedules, startDate, endDate);
            IList<ICalendarItem> ret = new List<ICalendarItem>();
            if (checkPermission)
            {
                ret = DeliveryManager.Find(filter, FetchOptions.All).Select(t => new DeliveryCalendarItem(t)).Cast<ICalendarItem>().ToList();
            }
            else
            {
                SecurityService.RunWithElevatedPrivilegies(() => ret = DeliveryManager.Find(filter, FetchOptions.All).Select(t => new DeliveryCalendarItem(t)).Cast<ICalendarItem>().ToList());
            }
            return ret;
        }

        public ICollection<ICalendarPlannedItem> GetRePlannedItems(IUser user)
        {
            return new List<ICalendarPlannedItem>();
        }

        public ICollection<ICalendarPlannedItem> GetUnPlannedItems(IUser user)
        {
            return new List<ICalendarPlannedItem>();
        }

        public IDictionary<ISchedule, ICollection<ICalendarItem>> CrossingItems(ICollection<ISchedule> schedules,
            DateTime startDate, DateTime endDate)
        {

            if (schedules.All(s => s.Owner == null))
                return new Dictionary<ISchedule, ICollection<ICalendarItem>>();
            startDate = new DateTime(startDate.Ticks + 1000000000); //необходимо для того, чтобы события не пересекались, если время начала одного события = времени завершения другого
            endDate = new DateTime(endDate.Ticks - 1000000000); //необходимо для того, чтобы события не пересекались, если время начала одного события = времени завершения другого
            var filter = GetFilter(schedules, startDate, endDate);
            var list = new List<IDelivery>();
            SecurityService.RunWithElevatedPrivilegies(() => list = DeliveryManager.Find(filter, FetchOptions.All).ToList());
            var ret = schedules.ToDictionary<ISchedule, ISchedule, ICollection<ICalendarItem>>(schedule => schedule, schedule =>
                    list.Where(e => e.Executor == schedule.Owner)
                        .Select(e => new DeliveryCalendarItem(e)
                        {
                            OnlyInfo = !SecurityService.CanCheckPermission(PermissionProvider.ViewTaskPermission, e) ||
                                        (SecurityService.CanCheckPermission(PermissionProvider.ViewTaskPermission, e)
                                            && !SecurityService.HasPermission(PermissionProvider.ViewTaskPermission, e))
                        })
                        .Cast<ICalendarItem>()
                        .ToList()

                );
            return ret.Where(s => s.Value.Any()).ToDictionary(s => s.Key, s => s.Value);
        }

        public ICalendarItem AddItem(IUser user, string id, DateTime startDate, DateTime endDate, bool removeOther)
        {
            return null;
        }

        public ICalendarItem ModifyTime(string id, int dayDelta, int minuteDelta, bool moved)
        {
            return null;
        }

        public void Remove(string id)
        {

        }

        public bool External
        {
            get { return false; }
        }
    }

}