﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using EleWise.ELMA.Common.Models;
using EleWise.ELMA.ComponentModel;
using EleWise.ELMA.CRM.Models;
using EleWise.ELMA.Extensions;
using EleWise.ELMA.Logging;
using EleWise.ELMA.Model.Events;
using EleWise.ELMA.Model.Services;
using EleWise.ELMA.Runtime.NH.Listeners;
using EleWise.ELMA.Security;
using EleWise.ELMA.Security.Managers;
using EleWise.ELMA.Services;
using NHibernate.Event;

namespace EntityEvents.Extensions
{
    [Component]
    public class EntityEvent : EntityEventsListener
    {
        public override void OnPostUpdateCollection(PostCollectionUpdateEvent @event)
        {
            var contr = @event.AffectedOwnerOrNull as IContractor;
            if (contr != null)
            {
                var collection = @event.Collection;
                var collectionEntry = @event.Session.PersistenceContext.GetCollectionEntry(@event.Collection);
                var collectionEntries = collection.Entries(collectionEntry.LoadedPersister);

                var listChars = new List<string> { " ", "-", "(", ")" };
                var index = 1;
                foreach (var entry in collectionEntries)
                {
                    if (!(entry is IPhone)) continue;
                    var phone = entry as IPhone;
                    long number;
                    var lastNumber = phone.PhoneString;
                    foreach (var str in listChars)
                    {
                        if (lastNumber != null)
                            lastNumber = lastNumber.Replace(str, string.Empty);
                    }
                    if (!long.TryParse(lastNumber, out number))
                        throw new Exception(string.Format("Телефон №{0} имеет недопустимые символы", index));
                    index++;
                }

            }
        }

        //Запись истории изменения имени контрагента
        public override void OnPostUpdate(PostUpdateEvent @event)
        {
            if (!(@event.Entity is IContractor)) return;
            var nameIndex = Array.IndexOf(@event.Persister.PropertyNames, "Name");

            var contractor = @event.Entity as IContractor;
            if ((string)@event.OldState[nameIndex] != (string)@event.State[nameIndex])
            {
                var comment = InterfaceActivator.Create<IComment>();
                comment.CreationAuthor = UserManager.Instance.Load(SecurityConstants.SystemUserUid);
                comment.CreationDate = DateTime.Now;
                comment.Text += string.Format("{2} изменил имя контрагента с {0} на {1}\r\n", @event.OldState[nameIndex],
                        @event.State[nameIndex], contractor.ChangeAuthor.FullName);
                comment.Save();
                contractor.Comments.Add(comment);
                var actionHandler = Locator.GetServiceNotNull<IEntityActionHandler>();
                actionHandler.ActionExecuted(EntityActionEventArgs.TryCreate(null, contractor,
                    ContractorActions.AddComment));
            }
        }
        
        //Проверка корректности введенного номера телефона на наличие посторонних символов/букв
        public override void OnPreUpdateCollection(PreCollectionUpdateEvent @event)
        {
            var contr = @event.AffectedOwnerOrNull as IContractor;
            if (contr != null)
            {
                var collectionEntry = @event.Session.PersistenceContext.GetCollectionEntry(@event.Collection);

                var newCollection = (@event.Collection as IEnumerable).Cast<object>().ToList(); //Новая коллекция
                var oldCollection = (collectionEntry.Snapshot as IEnumerable).Cast<object>().ToList(); //Старая коллекция

                var removed = oldCollection.Where(item => !newCollection.Contains(item)).ToArray(); //Удаленные элементы в новой коллекции
                var added = newCollection.Where(item => !oldCollection.Contains(item)).ToArray(); //Добавленные элементы в новой коллекции

                if (collectionEntry.Role.EndsWith(".Phone"))
                {
                    var comment = InterfaceActivator.Create<IComment>();
                    comment.CreationAuthor = UserManager.Instance.Load(SecurityConstants.SystemUserUid);
                    comment.CreationDate = DateTime.Now;
                    foreach (var add in added)
                    {
                        var phone = add as IPhone;
                        if (phone != null)
                        {
                            comment.Text += string.Format("Добавлен новый телефон {0}\r\n", phone.PhoneString);
                        }
                    }
                    foreach (var rem in removed)
                    {
                        var phone = rem as IPhone;
                        if (phone != null)
                        {
                            comment.Text += string.Format("Телефон {0} был удален\r\n", phone.PhoneString);
                        }
                    }
                    comment.Save();
                    contr.Comments.Add(comment);
                    var actionHandler = Locator.GetServiceNotNull<IEntityActionHandler>();
                    actionHandler.ActionExecuted(EntityActionEventArgs.TryCreate(null, contr,
                        ContractorActions.AddComment));
                }
            }
        }
        
        //Проверка на заполненность поля "Годовой доход", если поле не заполнено - событие прерывается
        public override bool OnPreUpdate(PreUpdateEvent @event)
        {
            if (@event.Entity is IContractor)
            {
                try
                {
                    const double zero = 0;
                    var nameIndex = Array.IndexOf(@event.Persister.PropertyNames, "AnnualIncome");
                    var annualIncomeValue = @event.State[nameIndex];
                    if (annualIncomeValue != null && !annualIncomeValue.ToString().IsNullOrWhiteSpace() && (double)annualIncomeValue != zero && (double)annualIncomeValue > zero)
                    {
                        Logger.Log.Error("Значение поля годовой доход заполнено корректно");
                        //Обработка события
                        return false;
                    }
                    Logger.Log.Error("Значение поля годовой доход меньше нуля, ноль или null");
                    return true; //Прервать событие
                }
                catch (Exception ex)
                {
                    Logger.Log.Error(ex.Message);
                    return true; //Прервать событие
                }
            }
            return false;
       }
    }
}
